/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.awt.EventQueue;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import nu.zoom.swing.desktop.frame.Desktop;
import nu.zoom.swing.desktop.frame.DetachableWorkbenchFrame;
import nu.zoom.swing.desktop.frame.FrameVisualPreferences;
import nu.zoom.swing.desktop.frame.WorkbenchFrameDelegate;
import nu.zoom.swing.desktop.frame.WorkbenchFrames;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InternalWorkbenchFrame
extends WorkbenchFrameDelegate {
    private final Log log = LogFactory.getLog(this.getClass());
    private final JInternalFrame frame;
    private boolean detaching = false;
    private final Desktop desktop;

    InternalWorkbenchFrame(DetachableWorkbenchFrame owner, JComponent content, JMenuBar frameMenu, boolean resizable, boolean maximizable, Preferences preferences, String preferencesKey, WorkbenchFrames workbenchFrames, Desktop desktop) {
        super(owner, preferences, preferencesKey, content, frameMenu, resizable, maximizable);
        this.desktop = desktop;
        this.frame = new JInternalFrame("", resizable, true, maximizable);
        if (frameMenu != null) {
            this.frame.setJMenuBar(frameMenu);
        }
        this.frame.getContentPane().add(content);
        this.layoutFrame();
        this.frame.addInternalFrameListener(new InternalFrameEventDispatcher());
        this.frame.setDefaultCloseOperation(0);
        desktop.addToDesktop(this.frame);
    }

    private void layoutFrame() {
        int yValue;
        int xValue;
        int heightValue;
        int widthValue;
        Integer y;
        Point defaultPosition = this.desktop.getNextDefaultPosition();
        int desktopwidth = this.desktop.getMaxWidth();
        int desktopheight = this.desktop.getMaxHeight();
        FrameVisualPreferences prefs = this.getFrameVisualPreferencesFromPreferences();
        Integer width = prefs != null ? prefs.getWidth() : null;
        Integer height = prefs != null ? prefs.getHeight() : null;
        Integer x = prefs != null ? prefs.getPositionx() : null;
        Integer n = y = prefs != null ? prefs.getPositiony() : null;
        if (width == null || height == null || x == null || y == null) {
            this.frame.pack();
            widthValue = this.frame.getWidth();
            heightValue = this.frame.getHeight();
            xValue = defaultPosition.x;
            yValue = defaultPosition.y;
        } else {
            xValue = x;
            yValue = y;
            widthValue = width;
            heightValue = height;
        }
        int xAdjusted = xValue;
        int yAdjusted = yValue;
        if (xAdjusted < 0 || xAdjusted > desktopwidth) {
            xAdjusted = defaultPosition.x;
        }
        if (yAdjusted < 0 || yAdjusted > desktopheight) {
            yAdjusted = defaultPosition.y;
        }
        int widthAdjusted = Math.max(widthValue, 40);
        int heightAdjusted = Math.max(heightValue, 40);
        int frameMaxWidth = xAdjusted + (int)((double)desktopwidth * 0.9);
        int frameMaxHeight = yAdjusted + (int)((double)desktopheight * 0.9);
        if (widthAdjusted > frameMaxWidth) {
            widthAdjusted = frameMaxWidth;
        }
        if (heightAdjusted > frameMaxHeight) {
            heightAdjusted = frameMaxHeight;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Layout frame: x=" + xAdjusted + " y=" + yAdjusted + " width=" + widthAdjusted + " height=" + heightAdjusted));
        }
        this.frame.setLocation(xAdjusted, yAdjusted);
        this.frame.setSize(widthAdjusted, heightAdjusted);
        this.frame.validate();
    }

    @Override
    void dispose() {
        this.savePreferences();
        this.frame.dispose();
    }

    @Override
    String getTitle() {
        return this.frame.getTitle();
    }

    @Override
    boolean isVisible() {
        return this.frame.isVisible();
    }

    @Override
    void moveToFront() {
        if (this.frame.isIcon()) {
            try {
                this.frame.setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.frame.toFront();
    }

    @Override
    void delegateSetIcons(List<ImageIcon> icons) {
        if (icons.size() > 0) {
            this.frame.setFrameIcon(icons.get(0));
        }
    }

    @Override
    void setTitle(String newTitle) {
        this.frame.setTitle(newTitle);
    }

    @Override
    void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    @Override
    void savePreferencesAndDisposeOfNativeFrameWithoutCallbacks() {
        this.detaching = true;
        this.dispose();
    }

    @Override
    protected FrameVisualPreferences getFrameVisualPreferencesFromFrame() {
        FrameVisualPreferences prefs = null;
        if (this.frame.isIcon()) {
            this.log.trace((Object)"Disposing frame is Iconified, trying to un-iconify it");
            try {
                this.frame.setIcon(false);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        if (!this.frame.isIcon()) {
            Integer width = new Integer(this.frame.getWidth());
            Integer height = new Integer(this.frame.getHeight());
            Point position = this.frame.getLocation();
            Integer x = new Integer(position.x);
            Integer y = new Integer(position.y);
            prefs = new FrameVisualPreferences(width, height, x, y);
        }
        return prefs;
    }

    class InternalFrameEventDispatcher
    extends InternalFrameAdapter {
        InternalFrameEventDispatcher() {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("Internal frame event dispatcher not called in EventQueue DispatchThread");
            }
            if (!InternalWorkbenchFrame.this.detaching) {
                InternalWorkbenchFrame.this.owner.fireFrameClosed();
            }
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalStateException("Internal frame event dispatcher not called in EventQueue DispatchThread");
            }
            InternalWorkbenchFrame.this.owner.dispose();
        }
    }
}

