/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import nu.zoom.swing.desktop.frame.DetachableWorkbenchFrame;
import nu.zoom.swing.desktop.frame.FrameVisualPreferences;
import nu.zoom.swing.desktop.frame.WorkbenchFrameDelegate;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalWorkbenchFrame
extends WorkbenchFrameDelegate {
    private JFrame frame;
    private Log log = LogFactory.getLog(this.getClass());
    private boolean attaching = false;

    ExternalWorkbenchFrame(DetachableWorkbenchFrame owner, JComponent content, JMenuBar frameMenu, boolean resizable, boolean maximizable, Preferences preferences, String preferencesKey) {
        super(owner, preferences, preferencesKey, content, frameMenu, resizable, maximizable);
        this.frame = new JFrame();
        if (frameMenu != null) {
            this.frame.setJMenuBar(frameMenu);
        }
        this.frame.getContentPane().add(content);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowListener());
        this.layoutFrame();
    }

    @Override
    protected FrameVisualPreferences getFrameVisualPreferencesFromFrame() {
        Dimension size = this.frame.getSize();
        Point position = this.frame.getLocation();
        FrameVisualPreferences prefs = new FrameVisualPreferences(size.width, size.height, position.x, position.y);
        return prefs;
    }

    private void layoutFrame() {
        int yValue;
        int xValue;
        int heightValue;
        int widthValue;
        Integer y;
        FrameVisualPreferences prefs = this.getFrameVisualPreferencesFromPreferences();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int desktopwidth = screenSize.width;
        int desktopheight = screenSize.height;
        int defaultX = 10;
        int defaultY = 10;
        Integer width = prefs != null ? prefs.getWidth() : null;
        Integer height = prefs != null ? prefs.getHeight() : null;
        Integer x = prefs != null ? prefs.getPositionx() : null;
        Integer n = y = prefs != null ? prefs.getPositiony() : null;
        if (width == null || height == null || x == null || y == null) {
            this.frame.pack();
            widthValue = this.frame.getWidth();
            heightValue = this.frame.getHeight();
            xValue = defaultX;
            yValue = defaultY;
        } else {
            xValue = x;
            yValue = y;
            widthValue = width;
            heightValue = height;
        }
        int xAdjusted = xValue;
        int yAdjusted = yValue;
        if (xAdjusted < 0 || xAdjusted > desktopwidth) {
            xAdjusted = defaultX;
        }
        if (yAdjusted < 0 || yAdjusted > desktopheight) {
            yAdjusted = defaultY;
        }
        int widthAdjusted = Math.max(widthValue, 40);
        int heightAdjusted = Math.max(heightValue, 40);
        int frameMaxWidth = xAdjusted + (int)((double)desktopwidth * 0.9);
        int frameMaxHeight = yAdjusted + (int)((double)desktopheight * 0.9);
        if (widthAdjusted > frameMaxWidth) {
            widthAdjusted = frameMaxWidth;
        }
        if (heightAdjusted > frameMaxHeight) {
            heightAdjusted = frameMaxHeight;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Layout frame: x=" + xAdjusted + " y=" + yAdjusted + " width=" + widthAdjusted + " height=" + heightAdjusted));
        }
        this.frame.setLocation(xAdjusted, yAdjusted);
        this.frame.setSize(widthAdjusted, heightAdjusted);
        this.frame.validate();
    }

    @Override
    void dispose() {
        this.savePreferences();
        this.frame.dispose();
    }

    @Override
    String getTitle() {
        return this.frame.getTitle();
    }

    @Override
    boolean isVisible() {
        return this.frame.isVisible();
    }

    @Override
    void moveToFront() {
        this.frame.toFront();
    }

    @Override
    void delegateSetIcons(List<ImageIcon> icons) {
        ArrayList<Image> images = new ArrayList<Image>();
        for (ImageIcon imageIcon : icons) {
            images.add(imageIcon.getImage());
        }
        this.frame.setIconImages(images);
    }

    @Override
    void setTitle(String newTitle) {
        this.frame.setTitle(newTitle);
    }

    @Override
    void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    @Override
    void savePreferencesAndDisposeOfNativeFrameWithoutCallbacks() {
        this.attaching = true;
        this.dispose();
    }

    class WindowListener
    extends WindowAdapter {
        WindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ExternalWorkbenchFrame.this.owner.dispose();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (!ExternalWorkbenchFrame.this.attaching) {
                ExternalWorkbenchFrame.this.owner.fireFrameClosed();
            }
        }
    }
}

