/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import nu.zoom.swing.desktop.common.BackendException;
import nu.zoom.swing.desktop.frame.AbstractWorkbenchFrame;
import nu.zoom.swing.desktop.frame.Desktop;
import nu.zoom.swing.desktop.frame.ExternalWorkbenchFrame;
import nu.zoom.swing.desktop.frame.InternalWorkbenchFrame;
import nu.zoom.swing.desktop.frame.WorkbenchFrameDelegate;
import nu.zoom.swing.desktop.frame.WorkbenchFrames;
import nu.zoom.swing.desktop.preferences.InvalidDataTypeException;
import nu.zoom.swing.desktop.preferences.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DetachableWorkbenchFrame
extends AbstractWorkbenchFrame {
    private Log log = LogFactory.getLog(this.getClass());
    private final WorkbenchFrames workbenchFrames;
    private final String internalFramePreferencesKey;
    private final String externalFramePreferencesKey;
    private WorkbenchFrameDelegate delegate;
    private boolean detached = false;
    private final String preferencesKey;
    private final Preferences preferences;
    private final Desktop desktop;
    private static final String DETACHED = ".detached";

    public DetachableWorkbenchFrame(JComponent content, JMenuBar frameMenu, boolean resizable, boolean maximizable, WorkbenchFrames workbenchFrames, Preferences preferences, String preferencesKey, Desktop desktop) {
        this.preferences = preferences;
        this.preferencesKey = preferencesKey;
        this.internalFramePreferencesKey = preferencesKey + ".int";
        this.externalFramePreferencesKey = preferencesKey + ".ext";
        this.workbenchFrames = workbenchFrames;
        this.desktop = desktop;
        try {
            String detachedPrefsValue = preferences.getString(preferencesKey + DETACHED);
            this.detached = detachedPrefsValue != null && detachedPrefsValue.equals(Boolean.TRUE.toString());
        }
        catch (InvalidDataTypeException e) {
            this.log.warn((Object)e);
            this.detached = false;
        }
        catch (BackendException e) {
            this.log.warn((Object)e);
            this.detached = false;
        }
        this.delegate = this.detached ? new ExternalWorkbenchFrame(this, content, frameMenu, resizable, maximizable, preferences, this.externalFramePreferencesKey) : new InternalWorkbenchFrame(this, content, frameMenu, resizable, maximizable, preferences, this.internalFramePreferencesKey, workbenchFrames, desktop);
        this.delegate.setTitle("");
    }

    @Override
    protected void delegateDispose() {
        try {
            this.preferences.setString(this.preferencesKey + DETACHED, Boolean.toString(this.detached));
        }
        catch (BackendException e) {
            this.log.warn((Object)e);
        }
        this.delegate.dispose();
    }

    @Override
    public String getTitle() {
        return this.delegate.getTitle();
    }

    @Override
    public void setTitle(String newTitle) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Trying to set frame title to: " + newTitle));
        }
        String title = this.workbenchFrames.getUniqueTitle(newTitle);
        this.delegate.setTitle(title);
        this.workbenchFrames.titleChanged(this);
    }

    @Override
    public boolean isVisible() {
        return this.delegate.isVisible();
    }

    @Override
    public void moveToFront() {
        this.delegate.moveToFront();
    }

    @Override
    public void setFrameIcon(ImageIcon icon) {
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        icons.add(icon);
        this.setFrameIcon(icons);
    }

    @Override
    public void setFrameIcon(List<ImageIcon> icons) {
        this.delegate.setFrameIcon(icons);
    }

    @Override
    public void setVisible(boolean visible) {
        this.delegate.setVisible(visible);
    }

    @Override
    public boolean isDetached() {
        return this.detached;
    }

    @Override
    public void attach() {
        InternalWorkbenchFrame internalDelegate = new InternalWorkbenchFrame(this, this.delegate.getContent(), this.delegate.getFrameMenu(), this.delegate.isResizable(), this.delegate.isMaximizable(), this.preferences, this.internalFramePreferencesKey, this.workbenchFrames, this.desktop);
        this.switchDelegates(internalDelegate);
        this.detached = false;
    }

    @Override
    public void detach() {
        ExternalWorkbenchFrame externalDelegate = new ExternalWorkbenchFrame(this, this.delegate.getContent(), this.delegate.getFrameMenu(), this.delegate.isResizable(), this.delegate.isMaximizable(), this.preferences, this.externalFramePreferencesKey);
        this.switchDelegates(externalDelegate);
        this.detached = true;
    }

    private void switchDelegates(WorkbenchFrameDelegate newDelegate) {
        this.delegate.savePreferencesAndDisposeOfNativeFrameWithoutCallbacks();
        String title = this.delegate.getTitle();
        newDelegate.setTitle(title);
        List<ImageIcon> icons = this.delegate.getFrameIcons();
        if (icons != null && icons.size() > 0) {
            newDelegate.setFrameIcon(icons);
        }
        this.delegate = newDelegate;
        this.delegate.setVisible(true);
    }
}

