/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DesktopScrollbarManager
implements DesktopManager {
    private DesktopManager delegate;
    private JScrollPane desktopScroller;
    private JDesktopPane desktop;
    private Log log = LogFactory.getLog(this.getClass());

    DesktopScrollbarManager(JDesktopPane desktop) {
        this.desktop = desktop;
        this.delegate = desktop.getDesktopManager();
        this.desktopScroller = new JScrollPane(desktop);
        desktop.setDesktopManager(this);
    }

    JScrollPane getDesktopScroller() {
        return this.desktopScroller;
    }

    @Override
    public void beginDraggingFrame(JComponent f) {
        this.delegate.beginDraggingFrame(f);
    }

    @Override
    public void endDraggingFrame(JComponent f) {
        this.delegate.endDraggingFrame(f);
        this.resizeDesktop();
    }

    @Override
    public void endResizingFrame(JComponent f) {
        this.delegate.endResizingFrame(f);
        this.resizeDesktop();
    }

    @Override
    public void beginResizingFrame(JComponent f, int direction) {
        this.delegate.beginResizingFrame(f, direction);
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY) {
        this.delegate.dragFrame(f, newX, newY);
    }

    @Override
    public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        this.delegate.resizeFrame(f, newX, newY, newWidth, newHeight);
    }

    @Override
    public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        this.delegate.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        this.delegate.activateFrame(f);
    }

    @Override
    public void closeFrame(JInternalFrame f) {
        this.delegate.closeFrame(f);
    }

    @Override
    public void deactivateFrame(JInternalFrame f) {
        this.delegate.deactivateFrame(f);
    }

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        this.delegate.deiconifyFrame(f);
    }

    @Override
    public void iconifyFrame(JInternalFrame f) {
        this.delegate.iconifyFrame(f);
    }

    @Override
    public void maximizeFrame(JInternalFrame f) {
        this.delegate.maximizeFrame(f);
    }

    @Override
    public void minimizeFrame(JInternalFrame f) {
        this.delegate.minimizeFrame(f);
    }

    @Override
    public void openFrame(JInternalFrame f) {
        this.delegate.openFrame(f);
    }

    private void setAllSize(Dimension d) {
        this.desktop.setMinimumSize(d);
        this.desktop.setMaximumSize(d);
        this.desktop.setPreferredSize(d);
    }

    private void resizeDesktop() {
        if (this.desktop.isVisible()) {
            int x = 0;
            int y = 0;
            if (this.desktopScroller != null) {
                this.log.trace((Object)"Desktop resized, recalculating desktop dimension");
                JInternalFrame[] allFrames = this.desktop.getAllFrames();
                for (int i = 0; i < allFrames.length; ++i) {
                    x = Math.max(x, allFrames[i].getX() + allFrames[i].getWidth());
                    y = Math.max(y, allFrames[i].getY() + allFrames[i].getHeight());
                }
                Dimension d = this.desktopScroller.getVisibleRect().getSize();
                if (this.desktopScroller.getBorder() != null) {
                    Insets scrollInsets = this.desktopScroller.getBorder().getBorderInsets(this.desktopScroller);
                    d.setSize(d.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, d.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
                }
                if ((double)x <= d.getWidth()) {
                    x = (int)d.getWidth() - 20;
                }
                if ((double)y <= d.getHeight()) {
                    y = (int)d.getHeight() - 20;
                }
                this.setAllSize(new Dimension(x, y));
                this.desktopScroller.invalidate();
                this.desktopScroller.validate();
            }
        }
    }
}

