/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchKeybinding;
import nu.zoom.swing.desktop.WorkbenchMenuBar;
import nu.zoom.swing.desktop.frame.DesktopScrollbarManager;
import nu.zoom.swing.desktop.frame.DetachableWorkbenchFrame;
import nu.zoom.swing.desktop.frame.WorkbenchFrames;
import nu.zoom.swing.desktop.preferences.Preferences;
import nu.zoom.swing.desktop.worker.WorkerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

public class Desktop
implements WorkbenchKeybinding {
    private Log log = LogFactory.getLog(this.getClass());
    private static final Point[] defaultOpenPoints = new Point[]{new Point(5, 5), new Point(15, 15), new Point(25, 25), new Point(35, 35), new Point(45, 45)};
    private int currentDefaultPoint = 0;
    private final WorkbenchFrames workbenchFrames;
    private final Preferences preferences;
    private final Workbench workbench;
    private final JDesktopPane desktopPane;
    private final DesktopScrollbarManager desktopmanager;

    public Desktop(Messages messages, WorkbenchMenuBar workbenchMenuBar, Preferences preferences, Workbench workbench) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Not running on event queue");
        }
        this.preferences = preferences;
        this.workbench = workbench;
        this.workbenchFrames = new WorkbenchFrames(messages, workbenchMenuBar);
        this.desktopPane = new JDesktopPane();
        this.desktopmanager = new DesktopScrollbarManager(this.desktopPane);
    }

    public WorkbenchFrame createFrame(String preferencesKey, JComponent content, JMenuBar menu, boolean resizable, boolean maximizable) {
        DetachableWorkbenchFrame frame = new DetachableWorkbenchFrame(content, menu, resizable, maximizable, this.workbenchFrames, this.preferences, preferencesKey, this);
        return this.postCreate(frame);
    }

    private WorkbenchFrame postCreate(WorkbenchFrame frame) {
        this.workbenchFrames.addFrame(frame);
        this.log.trace((Object)"Decorating workbench frame with an event queue worker proxy");
        WorkbenchFrame proxy = WorkerFactory.decorate((Object)frame, WorkbenchFrame.class);
        return proxy;
    }

    public void closeAll() {
        this.workbenchFrames.closeAll();
    }

    public JComponent getDesktopPane() {
        return this.desktopmanager.getDesktopScroller();
    }

    synchronized Point getNextDefaultPosition() {
        ++this.currentDefaultPoint;
        if (this.currentDefaultPoint >= defaultOpenPoints.length) {
            this.currentDefaultPoint = 0;
        }
        return defaultOpenPoints[this.currentDefaultPoint];
    }

    int getMaxWidth() {
        return this.workbench.getDialogOwner().getWidth();
    }

    int getMaxHeight() {
        return this.workbench.getDialogOwner().getHeight();
    }

    void addToDesktop(JInternalFrame frame) {
        this.desktopPane.add(frame);
    }

    @Override
    public void registerKeyboardAction(ActionListener anAction, KeyStroke aKeyStroke, int aCondition) {
        this.desktopPane.registerKeyboardAction(anAction, aKeyStroke, aCondition);
    }

    @Override
    public void registerKeyboardAction(ActionListener anAction, String aCommand, KeyStroke aKeyStroke, int aCondition) {
        this.desktopPane.registerKeyboardAction(anAction, aCommand, aKeyStroke, aCondition);
    }
}

