/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.frame;

import java.util.ArrayList;
import java.util.UUID;
import javax.swing.ImageIcon;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchFrameListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractWorkbenchFrame
implements WorkbenchFrame {
    private Log log = LogFactory.getLog(this.getClass());
    private final String guid;
    private final ArrayList<WorkbenchFrameListener> frameListeners = new ArrayList();

    public AbstractWorkbenchFrame() {
        this.guid = UUID.randomUUID().toString();
    }

    @Override
    public synchronized void addFrameListener(WorkbenchFrameListener listener) {
        if (listener != null && !this.frameListeners.contains(listener)) {
            this.frameListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeFrameListener(WorkbenchFrameListener listener) {
        if (listener != null) {
            this.frameListeners.remove(listener);
        }
    }

    protected synchronized void fireFrameClosed() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Informing " + this.frameListeners.size() + " listeners that frame is closed"));
        }
        for (int f = 0; f < this.frameListeners.size(); ++f) {
            this.frameListeners.get(f).frameClosed(this);
        }
    }

    protected synchronized void fireFrameWillDispose() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Informing " + this.frameListeners.size() + " listeners that frame will dispose"));
        }
        for (int f = 0; f < this.frameListeners.size(); ++f) {
            this.frameListeners.get(f).frameWillDispose(this);
        }
    }

    @Override
    public void dispose() {
        this.fireFrameWillDispose();
        this.delegateDispose();
    }

    protected abstract void delegateDispose();

    @Override
    public abstract void moveToFront();

    @Override
    public abstract void setFrameIcon(ImageIcon var1);

    @Override
    public abstract String getTitle();

    @Override
    public abstract void setTitle(String var1);

    @Override
    public abstract void setVisible(boolean var1);

    @Override
    public abstract boolean isVisible();

    @Override
    public abstract void attach();

    @Override
    public abstract void detach();

    @Override
    public abstract boolean isDetached();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractWorkbenchFrame other = (AbstractWorkbenchFrame)obj;
        return !(this.guid == null ? other.guid != null : !this.guid.equals(other.guid));
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.guid != null ? this.guid.hashCode() : 0);
        return hash;
    }
}

