/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import nu.zoom.swing.desktop.Workbench;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

public class OkCancelDialog {
    private Log log = LogFactory.getLog(this.getClass());
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private int exitStatus = 2;

    public OkCancelDialog(Workbench wb, Messages messages, String dialogTitleKey, String messageKey, String okMessageKey, String cancelMessageKey) {
        this.log.trace((Object)"Constructing an OkCancelDialog");
        String message = messages.getMessage(messageKey);
        String title = messages.getMessage(dialogTitleKey);
        String okMessage = messages.getMessage(okMessageKey);
        String cancelMessage = messages.getMessage(cancelMessageKey);
        final JDialog dlg = new JDialog(wb.getDialogOwner());
        dlg.setLocationRelativeTo(wb.getDialogOwner());
        dlg.setTitle(title);
        dlg.setModal(true);
        JTextArea messageArea = new JTextArea(message);
        messageArea.setEditable(false);
        JButton okButton = new JButton(okMessage);
        JButton cancelButton = new JButton(cancelMessage);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OkCancelDialog.this.log.trace((Object)"OK event");
                OkCancelDialog.this.exitStatus = 1;
                dlg.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OkCancelDialog.this.log.trace((Object)"Cancel event");
                OkCancelDialog.this.exitStatus = 2;
                dlg.dispose();
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)messageArea, "Center");
        dlg.getContentPane().add((Component)buttonPanel, "South");
        dlg.pack();
        dlg.setVisible(true);
    }

    public int getExitStatus() {
        return this.exitStatus;
    }
}

