/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.swing.desktop.common.action;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.WorkbenchFrameListener;
import nu.zoom.swing.desktop.common.action.WorkbenchMessageAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

public abstract class ToggleFrameAction<T extends AbstractButton>
extends WorkbenchMessageAction
implements WorkbenchFrameListener {
    private Log log = LogFactory.getLog(this.getClass());
    private WorkbenchFrame frame = null;
    private T control;

    public ToggleFrameAction(Messages messages, T control) {
        super(messages);
        ((AbstractButton)control).setAction(this);
        this.control = control;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.validateFrame();
        this.log.trace((Object)"Toggling frame");
        this.setVisible(!this.isVisible());
    }

    public T getControl() {
        return this.control;
    }

    protected abstract WorkbenchFrame createFrame();

    public boolean isVisible() {
        this.validateFrame();
        return this.frame.isVisible();
    }

    public void setVisible(boolean visible) {
        this.validateFrame();
        this.frame.setVisible(visible);
    }

    private void validateFrame() {
        if (this.frame == null) {
            this.frame = this.createFrame();
            if (this.frame == null) {
                throw new IllegalStateException("createFrame must not return null");
            }
            this.frame.addFrameListener(this);
        }
    }

    @Override
    public void frameClosed(WorkbenchFrame frame) {
        this.log.trace((Object)"Frame closed event");
        frame.removeFrameListener(this);
        this.frame = null;
        ((AbstractButton)this.control).setSelected(false);
    }

    @Override
    public void frameWillDispose(WorkbenchFrame frame) {
    }
}

