/*
 * Copyright (C) 2006 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.worker;

import java.lang.reflect.Proxy;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.InterceptorStack;
import org.ops4j.gaderian.ServiceInterceptorFactory;
import org.ops4j.gaderian.internal.Module;

/**
 * 
 * @author $Author: johan $
 * @version $Revision: 1.1 $
 * 
 */
public class WorkerInterceptorFactory implements ServiceInterceptorFactory {
	private Log log = LogFactory.getLog(getClass());

	public WorkerInterceptorFactory() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.apache.hivemind.ServiceInterceptorFactory#createInterceptor(org.apache.hivemind.InterceptorStack,
	 *      org.apache.hivemind.internal.Module, java.util.List)
	 */
	@SuppressWarnings("unchecked")
	public void createInterceptor(InterceptorStack stack,
			Module invokingModule, List parameters) {
		log.trace("Instantiating WorkerInvocationHandler");
		WorkerInvocationHandler handler = new WorkerInvocationHandler(stack
				.peek());
		log.trace("Creating interceptor");
		Object interceptor = Proxy.newProxyInstance(stack.peek().getClass()
				.getClassLoader(), new Class[] { stack.getServiceInterface() },
				handler);
		log.trace("Pushing interceptor on the stack");
		stack.push(interceptor);
	}

}
