/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.worker;


/**
 * Interface that captures a typical call sequence for a GUI triggered
 * operation. This interface is not really useful in itself except to expres the
 * event queue policy of the methods.
 * 
 * @param <E>
 *            The event type.
 * @param <W>
 *            The background work thread input data type
 * @param <C>
 *            The input data type to the callback operation.
 * @author $Author$
 * @version $Revision$
 * 
 */
public interface SwingWorker<E, W, C> {
	/**
	 * Typically the first method called as part of an actionPerformed call on a
	 * GUI component.
	 * 
	 * @param eventData
	 *            Event data (usually from Swing/AWT).
	 */
	@EventQueuePolicy(Policy.EVENT_QUEUE)
	public void event(final E eventData);

	/**
	 * Typically the method that performs non-GUI related operations, runs in
	 * another thread than the GUI thread.
	 * 
	 * @param workData
	 *            The input data to the background operation.
	 */
	@EventQueuePolicy(Policy.NOT_EVENT_QUEUE)
	public void doWork(final W workData);

	/**
	 * Typically called when the background operation has completed to indicate
	 * the result of the background operation. Runs on the EventQueue thread so
	 * that Swing components can be updated.
	 * 
	 * @param callbackData
	 *            The result of the background operation.
	 */
	@EventQueuePolicy(Policy.EVENT_QUEUE)
	public void callback(final C callbackData);
}
