/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.preferences;

/**
 * Indicates that the data type stored in the preferences backend does not match
 * the expected return type. For example getString was called but the actual
 * data in the preferences is not a String.
 * 
 * @author $Author: johan $
 * @version $Revision: 1.4 $
 */
public class InvalidDataTypeException extends Exception {
	private static final long serialVersionUID = -80668822894039030L;

	public InvalidDataTypeException() {
		super();
	}

	public InvalidDataTypeException(String message) {
		super(message);
	}

	public InvalidDataTypeException(Throwable cause) {
		super(cause);
	}

	public InvalidDataTypeException(String message, Throwable cause) {
		super(message, cause);
	}

}
