/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.plugin.sysprops;

import java.awt.event.ActionEvent;

import javax.swing.JMenuItem;

import org.ops4j.gaderian.Messages;

import nu.zoom.swing.desktop.PlugIn;
import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchListener;
import nu.zoom.swing.desktop.common.action.WorkbenchAction;
import nu.zoom.swing.dialog.SystemPropertiesDialog;

/**
 * Plugin that can open a dialog showing some system properties.
 * 
 * @author $Author$
 * @version $Revision$
 * 
 */
public class SystemProperties implements PlugIn, WorkbenchListener {
	private Workbench workbench;

	private Messages messages;

	public SystemProperties() {
		super();
	}

	/**
	 * @param messages The messages to set.
	 */
	public void setMessages(Messages messages) {
		this.messages = messages;
	}

	/**
	 * @param workbench The workbench to set.
	 */
	public void setWorkbench(Workbench workbench) {
		this.workbench = workbench;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.PlugIn#initialize()
	 */
	public void initialize() throws Exception {
		workbench.addWorkBenchListener(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.WorkbenchListener#start()
	 */
	public void start() {
		SysPropsAction action = new SysPropsAction();
		action.setName(messages.getMessage("sysprops.menu"));
		workbench.getMenuBar().addToHelpMenu(new JMenuItem(action));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.WorkbenchListener#close()
	 */
	public void close() {
	}

	@SuppressWarnings("serial")
	class SysPropsAction extends WorkbenchAction {
		/*
		 * (non-Javadoc)
		 * 
		 * @see nu.zoom.swing.desktop.component.WorkbenchAction#actionPerformed(java.awt.event.ActionEvent)
		 */
		@Override
		public void actionPerformed(ActionEvent e) {
			SystemPropertiesDialog dlg = new SystemPropertiesDialog();
			dlg.setLocationRelativeTo(workbench.getDialogOwner());
			dlg.setModal(true) ;
			dlg.pack();
			dlg.setVisible(true);
		}
	}

}
