/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.plugin.laf;

import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

/**
 * @author $Author: johan $
 * @version $Revision: 1.1 $
 */
public class InstalledLookAndFeel implements DesktopLookAndFeel
{
	private LookAndFeel swingLaf;

	public InstalledLookAndFeel(LookAndFeel swingLaf) {
		super();
		this.swingLaf = swingLaf;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.plugin.DesktopLookAndFeel#getName()
	 */
	public String getName()
	{
		return swingLaf.getName() ;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.plugin.DesktopLookAndFeel#getToolTip()
	 */
	public String getToolTip()
	{
		return swingLaf.getDescription();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.plugin.DesktopLookAndFeel#isAvailable()
	 */
	public boolean isAvailable()
	{
		return swingLaf.isSupportedLookAndFeel();
	}

	/* (non-Javadoc)
	 * @see nu.zoom.swing.desktop.plugin.laf.DesktopLookAndFeel#initialize()
	 */
	public void initialize() throws UnsupportedLookAndFeelException {
		UIManager.setLookAndFeel(swingLaf);
	}
}
