/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.plugin.laf;

import javax.swing.UnsupportedLookAndFeelException;

/**
 * @author $Author: johan $
 * @version $Revision: 1.1 $
 */
public interface DesktopLookAndFeel {
	/**
	 * The short name of this look and feel. Should be suitable to put in
	 * menues.
	 * 
	 * @return The name of this look and feel.
	 */
	public String getName();

	/**
	 * Get a description of this look and feel.
	 * 
	 * @return The description of this look and feel.
	 */
	public String getToolTip();

	/**
	 * Indicates if this look and feel is available for use.
	 * 
	 * @return True if the look and feel can be instantiated and used.
	 */
	public boolean isAvailable();

	/**
	 * Initialize the look and feel and make it active. This will be called when
	 * the user changes the look and feel from the menu and when the workbench
	 * starts for the preferred look and feel.
	 */
	public void initialize() throws UnsupportedLookAndFeelException;
}
