/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.plugin.laf;

import javax.swing.JCheckBoxMenuItem;

import nu.zoom.swing.desktop.Workbench;
import nu.zoom.swing.desktop.WorkbenchFrame;
import nu.zoom.swing.desktop.common.action.ToggleFrameAction;

import org.ops4j.gaderian.Messages;

/**
 * @author $Author: johan $
 * @version $Revision: 1.1 $
 */
@SuppressWarnings("serial")
public class ConfigureLookAndFeelAction extends ToggleFrameAction<JCheckBoxMenuItem> {

	private ConfigurableDesktopLookAndFeel laf;

	private Workbench workbench;

	private Messages messages;

	public ConfigureLookAndFeelAction(Workbench workbench, Messages messages,
			ConfigurableDesktopLookAndFeel laf) {
		super(messages, new JCheckBoxMenuItem());
		this.laf = laf;
		this.workbench = workbench;
		this.messages = messages;
		setName(messages.format("menu.claf.configure", laf.getName()));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.component.ToggleFrameAction#createFrame()
	 */
	protected WorkbenchFrame createFrame() {
		String title = messages.format("menu.claf.configure", laf.getName());
		WorkbenchFrame frame = workbench.createWorkbenchFrame("LAF"
				+ "." + laf.getName(), laf.getConfigurationComponent(), true,
				true);
		frame.setTitle(title);
		return frame;
	}
}
