/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.plugin.laf;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;

/**
 * @author $Author: johan $
 * @version $Revision: 1.1 $
 */
@SuppressWarnings("serial")
public class ActivateLookAndFeelAction extends AbstractAction
{
	private LookAndFeelManager manager;
	private DesktopLookAndFeel laf;

	public ActivateLookAndFeelAction(LookAndFeelManager manager,
			DesktopLookAndFeel laf) {
		super(laf.getName());
		putValue(Action.SHORT_DESCRIPTION, laf.getToolTip());
		this.laf = laf;
		this.manager = manager;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e)
	{
		manager.changeLookAndFeel(laf);
	}
}
