/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.plugin.console;

import nu.zoom.swing.desktop.PlugIn;
import nu.zoom.swing.text.ConsoleBean;

/**
 * A plug-in that handles a window where you can output text.
 * 
 * @version $Revision: 1.2 $
 * @author $Author: johan $
 */
public interface Console extends PlugIn
{

	/**
	 * Get the console class that can print messages in the console window.
	 * 
	 * @return The console.
	 */
	public ConsoleBean getConsole();
}
