/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.swing.desktop.plugin.browser;

import java.net.URL;

import nu.zoom.swing.desktop.PlugIn;

/**
 * A poor mans browser. The PlugIn delegates all rendering and HTML handling to
 * swing. So don't expect fancy web pages to work. The methods are thread safe.
 * 
 * @see javax.swing.JEditorPane
 * @version $Revision: 1.1 $
 * @author $Author: johan $
 */
public interface Browser extends PlugIn
{

	/**
	 * Opens a new browser window and displays the given URL.
	 * 
	 * @param url
	 *            The url to display. Can be null to open an empty browser.
	 * @return A new browser instance.
	 */
	public Browser open(URL url);

	/**
	 * Display an URL in the browser.
	 * 
	 * @param url
	 *            The url to display. Null is not allowed (ignored).
	 */
	public void show(URL url);
}
