/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.component;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;

import nu.zoom.swing.desktop.Workbench;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Messages;

/**
 * Used as a simple JOptionPane that retrieves messages from the HiveMind
 * messages class.
 * 
 * @version $Revision: 1.1 $
 * @author $Author: johan $
 */
public class OkCancelDialog
{
	private Log log = LogFactory.getLog(getClass());
	public static final int OK = 1;
	public static final int CANCEL = 2;
	private int exitStatus = CANCEL;

	/**
	 * Shows the message dialog.
	 * 
	 * @param wb
	 *            A reference to the workbench,
	 * @param messages
	 *            A reference to the messages class.
	 * @param dialogTitleKey
	 *            The message key used as a dialog title.
	 * @param messageKey
	 *            The message key for the message in the center of the dialog.
	 * @param okMessageKey
	 *            The label for the OK button.
	 * @param cancelMessageKey
	 *            The label for the cancel button.
	 */
	public OkCancelDialog(Workbench wb, Messages messages,
			String dialogTitleKey, String messageKey, String okMessageKey,
			String cancelMessageKey) {
		log.trace("Constructing an OkCancelDialog") ;
		String message = messages.getMessage(messageKey);
		String title = messages.getMessage(dialogTitleKey);
		String okMessage = messages.getMessage(okMessageKey);
		String cancelMessage = messages.getMessage(cancelMessageKey);
		final JDialog dlg = new JDialog(wb.getDialogOwner());
		dlg.setLocationRelativeTo(wb.getDialogOwner());
		dlg.setTitle(title);
		dlg.setModal(true);

		JTextArea messageArea = new JTextArea(message);
		messageArea.setEditable(false);
		JButton okButton = new JButton(okMessage);
		JButton cancelButton = new JButton(cancelMessage);

		okButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e)
			{
				log.trace("OK event") ;
				exitStatus = OK;
				dlg.dispose();
			}
		});

		cancelButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e)
			{
				log.trace("Cancel event") ;
				exitStatus = CANCEL;
				dlg.dispose();
			}
		});

		JPanel buttonPanel = new JPanel(new FlowLayout());
		buttonPanel.add(okButton);
		buttonPanel.add(cancelButton);
		dlg.getContentPane().setLayout(new BorderLayout());
		dlg.getContentPane().add(messageArea, BorderLayout.CENTER);
		dlg.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
		dlg.pack();
		dlg.setVisible(true);
	}

	/**
	 * Retrieve the button the user clicked to dispose of the dialog.
	 * 
	 * @return One of OK or CANCEL that indicates how the user disposed of the
	 *         dialog.
	 * @see #OK
	 * @see #CANCEL
	 */
	public int getExitStatus()
	{
		return exitStatus;
	}
}