/*
 * Copyright (C) 2006 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop.common.action;

import java.awt.event.ActionEvent;

import nu.zoom.swing.desktop.WorkbenchFrame;
import org.ops4j.gaderian.Messages;

/**
 * An action that detaches a frame from the desktop area and promotes it to a
 * top-level frame and back again. This is the action that is used on the window
 * menu to move frames in and out of the desktop area.
 */
@SuppressWarnings("serial")
public class DetachAction extends WorkbenchMessageAction {
	private WorkbenchFrame frame;

	/**
	 * Create a detach/attach action. Your messages must contain the following
	 * keys:<br />
	 * <ul>
	 * <li><code>menu.window.attach</code> The action text for attaching the
	 * frame to the workbench.</li>
	 * <li><code>menu.window.attach.tooltip</code> The tooltip text for
	 * attaching the frame to the workbench.</li>
	 * <li><code>menu.window.detach</code> The text for detaching the frame
	 * from the workbench.</li>
	 * <li><code>menu.window.detach.tooltip</code> The tooltip text for
	 * detaching the frame from the workbench.</li>
	 * <ul>
	 * 
	 * @param messages
	 * @param frame
	 */
	public DetachAction(Messages messages, WorkbenchFrame frame) {
		super(messages);
		this.frame = frame;
		if (frame.isDetached()) {
			setNameFromMessages("menu.window.attach");
			setToolTipFromMessages("menu.window.attach.tooltip");
		} else {
			setNameFromMessages("menu.window.detach");
			setToolTipFromMessages("menu.window.detach.tooltip");
		}
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (frame.isDetached()) {
			frame.attach();
			setNameFromMessages("menu.window.detach");
			setToolTipFromMessages("menu.window.detach.tooltip");
		} else {
			frame.detach();
			setNameFromMessages("menu.window.attach");
			setToolTipFromMessages("menu.window.attach.tooltip");
		}
	}
}