/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop;

/**
 * Acts as a mediator between the workbench Service and the user of the service.
 * In other words, classes that are interested in the life-cycle of the
 * workbench can register a listener for start and close events of the
 * workbench.
 * 
 * @see nu.zoom.swing.desktop.Workbench#addWorkBenchListener(WorkbenchListener)
 * @see nu.zoom.swing.desktop.Workbench#removeWorkBenchListener(WorkbenchListener)
 * @author $Author: johan $
 * @version $Revision: 1.3 $
 */
public interface WorkbenchListener
{
	/**
	 * Called by the Workbench when it is done constructing its own GUI elements
	 * but before the Desktop is displayed. An application can construct its GUI
	 * elements (typically adding things to the workbench menu) in this method.
	 * The callback will be in the AWT/Swing event thread.
	 */
	public void start();

	/**
	 * The workbench calls this method when it starts to shut down. Applications
	 * can clean up resources in this method (for example database connections).
	 * The callback will be in the AWT/Swing event thread.
	 */
	public void close();
}
