/*
 *  Copyright 2010 johan.
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  under the License.
 */
package nu.zoom.swing.desktop;

import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

/**
 * Exposes the global JDesktopPane input map to applications. More methods will
 * be added when needed (like unregistering and introspection).
 * @author Johan Maasing
 */
public interface WorkbenchKeybinding {

    /**
     * @see JComponent#registerKeyboardAction(java.awt.event.ActionListener, javax.swing.KeyStroke, int) 
     */
    public void registerKeyboardAction(ActionListener anAction,
            KeyStroke aKeyStroke,
            int aCondition);

    /**
     * @see JComponent#registerKeyboardAction(java.awt.event.ActionListener, java.lang.String, javax.swing.KeyStroke, int)
     */
    public void registerKeyboardAction(ActionListener anAction,
            String aCommand,
            KeyStroke aKeyStroke,
            int aCondition);
}
