/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package nu.zoom.swing.desktop;

/**
 * Workbench plug-ins must implement this interface and be registered as a
 * plug-in. Plug-ins must be registered so that the workbench can initialize
 * them after the workbench has been initalized (order is important here). Other
 * than that plug-ins are ordinary Hivemind services.
 * <p>
 * To register a plug-in with the workbench you add a configuration contribution
 * in the hivemodule descriptor. <br />
 * <code>&lt;contribution configuration-id="nu.zoom.swing.desktop.PlugIns"&gt;</code>
 * <code>    &lt;plugin serviceName="com.example.ServiceName"/&gt;</code>
 * <code>&lt;/contribution&gt;</code>
 * </p>
 * <p>
 * Plug-ins will only be loaded at startup (when the workbench starts) and will
 * never be unloaded. plug-ins that require clean up should register a
 * WorkbenchListener to be informed when the workbench closes. Notice that the
 * workbench may be restarted when changing Look And Feel, this implies a full
 * close of all GUI elements but the plug-in will not be re-initialized. A nice
 * trick for a plug-in is to register a workbench listener and use the
 * Preferences API to store the plug-in state when closing and re-read it when
 * starting.
 * </p>
 * 
 * @see nu.zoom.swing.desktop.Workbench
 * @see nu.zoom.swing.desktop.WorkbenchListener
 * @author $Author: johan $
 * @version $Revision: 1.3 $
 */
public interface PlugIn
{

	/**
	 * Called by the workbench to allow the plug-in to initalize itself. A
	 * plug-in may register a workbench listener in this method since this
	 * method is called before the workbench starts.
	 * 
	 * @see nu.zoom.swing.desktop.WorkbenchListener
	 * @throws Exception
	 */
	public void initialize() throws Exception;
}
