/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu Licensed under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
 * or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package nu.zoom.swing.desktop;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.gaderian.Registry;
import org.ops4j.gaderian.impl.RegistryBuilder;

/**
 * Main class that runs an empty desktop. Mainly used for testing.
 * 
 * @version $Revision: 1.4 $
 * @author $Author: johan $
 */
public class Desktop implements WorkbenchListener
{
	private Log log ;
	Registry registry;

	public static void main(String[] args)
	{
		Desktop app = new Desktop();
		app.startDesktop();
	}

	private Desktop() {
		log = LogFactory.getLog(getClass()) ;
	}

	private void startDesktop()
	{
		log.trace("Constructing default registry") ;
		registry = RegistryBuilder.constructDefaultRegistry();
		log.trace("Getting the workbench service") ;
		Workbench wb = (Workbench) registry.getService(Workbench.class);
		wb.addWorkBenchListener(this);
		log.trace("Starting the workbench") ;
		wb.start();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.gui.WorkbenchListener#close()
	 */
	public void close()
	{
		System.out.println("Workbench closed");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.gui.WorkbenchListener#start()
	 */
	public void start()
	{
		System.out.println("Workbench starting");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see nu.zoom.swing.desktop.WorkbenchListener#getRegistry()
	 */
	public Registry getRegistry()
	{
		return registry;
	}
}