/*
 * Copyright (C) 2005 Johan Maasing johan at zoom.nu
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package nu.zoom.swing.desktop;

/**
 * A workbench listener that can prevent the workbench from closing. This can be
 * used used by plugins/applications to prevent the workbench from closing if
 * the user has unsaved changes.
 * 
 * @version $Revision: 1.1 $
 * @author $Author: johan $
 */
public interface CloseVetoListener
{

	/**
	 * The workbench calls this method when it wants to close. The method will
	 * be called on the AWT/Swing EventQueue to make it easier for the listener
	 * to perform GUI operations. For example to open a dialog informing the
	 * user why the workbench can not close.
	 * 
	 * @return True to indicate that the workbench can continue closing. False
	 *         will prevent the workbench from closing.
	 */
	public boolean canClose();
}
