/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.plugindev;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.plugin.devel.plugins.JavaGradlePluginPlugin;
import org.gradle.plugin.devel.tasks.ValidatePlugins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDevPlugin
implements Plugin<Project> {
    private static final JavaLanguageVersion TOOLCHAIN_LANGUAGE_VERSION = JavaLanguageVersion.of((int)8);
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginDevPlugin.class);

    public void apply(Project project) {
        RepositoryHandler repositories = project.getRepositories();
        repositories.add((ArtifactRepository)repositories.mavenCentral());
        LOGGER.debug("Added repository 'MavenCentral'");
        Class<JavaGradlePluginPlugin> pluginClass = JavaGradlePluginPlugin.class;
        project.getPlugins().apply(pluginClass);
        LOGGER.debug("Applied plugin '" + pluginClass.getSimpleName() + "'");
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion().set((Object)TOOLCHAIN_LANGUAGE_VERSION);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("Build-Date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        attrs.put("Build-JDK", System.getProperty("java.version"));
        attrs.put("Build-Gradle", project.getGradle().getGradleVersion());
        project.getTasks().withType(Jar.class).configureEach(jar -> jar.getManifest().attributes((Map)attrs));
        LOGGER.debug("Configured jar files with manifest attributes");
        project.getTasks().withType(ValidatePlugins.class).configureEach(t -> {
            t.getFailOnWarning().set((Object)true);
            t.getEnableStricterValidation().set((Object)true);
        });
    }
}

