/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.plugindev;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.plugin.devel.plugins.JavaGradlePluginPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDevPlugin
implements Plugin<Project> {
    public static final String SOURCES_JAR_TASK_NAME = "sourcesJar";
    public static final String DOCS_JAR_TASK_NAME = "docsJar";
    private static final JavaVersion MINIMUM_GRADLE_JAVA_VERSION = JavaVersion.VERSION_1_8;
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginDevPlugin.class);

    public void apply(Project project) {
        RepositoryHandler repositories = project.getRepositories();
        repositories.add((ArtifactRepository)repositories.mavenCentral());
        LOGGER.debug("Added repository 'MavenCentral'");
        Class<JavaGradlePluginPlugin> pluginClass = JavaGradlePluginPlugin.class;
        project.getPlugins().apply(pluginClass);
        LOGGER.debug("Applied plugin '" + pluginClass.getSimpleName() + "'");
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        javaExtension.setSourceCompatibility(MINIMUM_GRADLE_JAVA_VERSION);
        javaExtension.setTargetCompatibility(MINIMUM_GRADLE_JAVA_VERSION);
        LOGGER.debug("Set Java source and target compatibility to " + MINIMUM_GRADLE_JAVA_VERSION);
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("Build-Date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        attrs.put("Build-JDK", System.getProperty("java.version"));
        attrs.put("Build-Gradle", project.getGradle().getGradleVersion());
        project.getTasks().withType(Jar.class).configureEach(jar -> jar.getManifest().attributes((Map)attrs));
        LOGGER.debug("Configured jar files with manifest attributes");
    }
}

