/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.plugindev;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.plugin.devel.plugins.JavaGradlePluginPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDevPlugin
implements Plugin<Project> {
    public static final String SOURCES_JAR_TASK_NAME = "sourcesJar";
    public static final String DOCS_JAR_TASK_NAME = "docsJar";
    private static final String MINIMUM_GRADLE_JAVA_VERSION = "1.8";
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginDevPlugin.class);

    public void apply(Project project) {
        Class<JavaGradlePluginPlugin> pluginClass = JavaGradlePluginPlugin.class;
        project.getPlugins().apply(pluginClass);
        LOGGER.debug("Applied plugin '" + pluginClass.getSimpleName() + "'");
        RepositoryHandler repositories = project.getRepositories();
        repositories.add((ArtifactRepository)repositories.mavenCentral());
        LOGGER.debug("Added repository 'MavenCentral'");
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        javaPluginConvention.setSourceCompatibility((Object)MINIMUM_GRADLE_JAVA_VERSION);
        javaPluginConvention.setTargetCompatibility((Object)MINIMUM_GRADLE_JAVA_VERSION);
        LOGGER.debug("Set Java source and target compatibility to 1.8");
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName("main");
        SourceDirectorySet allMainSources = mainSourceSet.getAllSource();
        project.getTasks().register(SOURCES_JAR_TASK_NAME, Jar.class, jar -> {
            jar.setDescription("Assembles a jar archive containing the main source code.");
            jar.setGroup("build");
            jar.setClassifier("sources");
            jar.from(new Object[]{allMainSources});
        });
        LOGGER.debug("Registered task 'sourcesJar'");
        project.getTasks().register(DOCS_JAR_TASK_NAME, Jar.class, jar -> {
            jar.setDescription("Assembles a jar archive containing the documentation for the main source code.");
            jar.setGroup("build");
            jar.setClassifier("javadoc");
            jar.into((Object)"javadoc").from(new Object[]{project.getTasks().findByName("javadoc")});
        });
        LOGGER.debug("Registered task 'docsJar'");
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("Build-Date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        attrs.put("Build-JDK", System.getProperty("java.version"));
        attrs.put("Build-Gradle", project.getGradle().getGradleVersion());
        project.getTasks().withType(Jar.class).configureEach(jar -> jar.getManifest().attributes((Map)attrs));
        LOGGER.debug("Configured jar files with manifest attributes");
    }
}

