/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.plugindev;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nu.studer.java.util.OrderedProperties;
import org.gradle.api.DefaultTask;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.CollectionUtils;

public class BackwardCompatiblePluginUnderTestMetadata
extends DefaultTask {
    private FileCollection pluginClasspath;
    private File outputDirectory;

    @Input
    protected List<String> getPaths() {
        FileCollection classpathFiles = this.getPluginClasspath() != null ? this.getPluginClasspath() : Collections.emptyList();
        return CollectionUtils.collect((Iterable)classpathFiles, file -> file.getAbsolutePath().replaceAll("\\\\", "/"));
    }

    @Classpath
    public FileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    public void setPluginClasspath(FileCollection pluginClasspath) {
        this.pluginClasspath = pluginClasspath;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @TaskAction
    public void generate() {
        OrderedProperties properties = new OrderedProperties.OrderedPropertiesBuilder().withSuppressDateInComment(true).build();
        List<String> paths = this.getPaths();
        if (!paths.isEmpty()) {
            String implementationClasspath = BackwardCompatiblePluginUnderTestMetadata.join(paths);
            properties.setProperty("implementation-classpath", implementationClasspath);
        }
        File outputFile = new File(this.getOutputDirectory(), "plugin-under-test-metadata.properties");
        BackwardCompatiblePluginUnderTestMetadata.saveProperties(properties, outputFile);
    }

    private static String join(Iterable<String> elements) {
        StringBuilder result = new StringBuilder();
        Iterator<String> parts = elements.iterator();
        if (parts.hasNext()) {
            result.append(parts.next());
            while (parts.hasNext()) {
                result.append(File.pathSeparator);
                result.append(parts.next());
            }
        }
        return result.toString();
    }

    private static void saveProperties(OrderedProperties properties, File outputFile) {
        try (FileOutputStream propertiesFileOutputStream = new FileOutputStream(outputFile);){
            properties.store((OutputStream)propertiesFileOutputStream, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }
}

