/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.jooq;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import nu.studer.gradle.jooq.JooqEdition;
import nu.studer.gradle.jooq.JooqExtension;
import nu.studer.gradle.jooq.JooqGenerate;
import nu.studer.gradle.jooq.util.Strings;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;

public class JooqPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"6.1")) < 0) {
            throw new IllegalStateException("This version of the jooq plugin is not compatible with Gradle < 6.1");
        }
        project.getPlugins().apply(JavaBasePlugin.class);
        JooqExtension jooqExtension = (JooqExtension)project.getExtensions().create("jooq", JooqExtension.class, new Object[0]);
        Configuration runtimeConfiguration = JooqPlugin.createJooqGeneratorRuntimeConfiguration(project);
        jooqExtension.getConfigurations().configureEach(config -> {
            String taskName = "generate" + (config.name.equals("main") ? "" : Strings.capitalize(config.name)) + "Jooq";
            TaskProvider jooq = project.getTasks().register(taskName, JooqGenerate.class, new Object[]{config, runtimeConfiguration});
            jooq.configure(task -> {
                task.setDescription(String.format("Generates the jOOQ sources from the %s jOOQ configuration.", config.name));
                task.setGroup("jOOQ");
            });
            SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            sourceSets.configureEach(sourceSet -> {
                if (sourceSet.getName().equals(config.name)) {
                    sourceSet.getJava().srcDir((Object)config.getGenerateSchemaSourceOnCompilation().flatMap(b -> b != false ? jooq.flatMap(JooqGenerate::getOutputDir) : config.getOutputDir()));
                    project.getDependencies().add(sourceSet.getImplementationConfigurationName(), (Object)"org.jooq:jooq");
                }
            });
        });
        JooqPlugin.enforceJooqEditionAndVersion(project, jooqExtension);
    }

    private static Configuration createJooqGeneratorRuntimeConfiguration(Project project) {
        Configuration jooqGeneratorRuntime = (Configuration)project.getConfigurations().create("jooqGenerator");
        jooqGeneratorRuntime.setDescription("The classpath used to invoke the jOOQ code generator. Add your JDBC driver, generator extensions, and additional dependencies here.");
        project.getDependencies().add(jooqGeneratorRuntime.getName(), (Object)"org.jooq:jooq-codegen");
        project.getDependencies().add(jooqGeneratorRuntime.getName(), (Object)"javax.xml.bind:jaxb-api:2.3.1");
        project.getDependencies().add(jooqGeneratorRuntime.getName(), (Object)"org.glassfish.jaxb:jaxb-core:2.3.0.1");
        project.getDependencies().add(jooqGeneratorRuntime.getName(), (Object)"org.glassfish.jaxb:jaxb-runtime:2.3.3");
        project.getDependencies().add(jooqGeneratorRuntime.getName(), (Object)"javax.activation:activation:1.1.1");
        return jooqGeneratorRuntime;
    }

    private static void enforceJooqEditionAndVersion(Project project, JooqExtension jooqExtension) {
        Set jooqGroupIds = Arrays.stream(JooqEdition.values()).map(JooqEdition::getGroupId).collect(Collectors.toSet());
        project.getConfigurations().configureEach(configuration -> configuration.getResolutionStrategy().eachDependency(details -> {
            ModuleVersionSelector requested = details.getRequested();
            if (jooqGroupIds.contains(requested.getGroup()) && requested.getName().startsWith("jooq")) {
                String group = ((JooqEdition)((Object)((Object)((Object)jooqExtension.getEdition().get())))).getGroupId();
                String version = (String)jooqExtension.getVersion().get();
                details.useTarget((Object)(group + ":" + requested.getName() + ":" + version));
            }
        }));
    }
}

