/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.jooq;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import nu.studer.gradle.jooq.JooqConfig;
import nu.studer.gradle.jooq.util.Objects;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jooq.codegen.GenerationTool;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Strategy;
import org.xml.sax.SAXException;

public class JooqGenerate
extends DefaultTask {
    private final Configuration jooqConfiguration;
    private final Provider<Configuration> normalizedJooqConfiguration;
    private final ConfigurableFileCollection runtimeClasspath;
    private final DirectoryProperty outputDir;
    private Action<? super Configuration> generationToolNormalization;
    private Action<? super JavaExecSpec> javaExecSpec;
    private Action<? super ExecResult> execResultHandler;
    private final ProjectLayout projectLayout;
    private final ExecOperations execOperations;
    private static final Action<Configuration> OUTPUT_DIRECTORY_NORMALIZATION = c -> c.getGenerator().getTarget().setDirectory(null);

    @Inject
    public JooqGenerate(JooqConfig config, FileCollection runtimeClasspath, ObjectFactory objects, ProviderFactory providers, ProjectLayout projectLayout, ExecOperations execOperations) {
        this.jooqConfiguration = config.getJooqConfiguration();
        this.normalizedJooqConfiguration = this.normalizedJooqConfigurationProvider(objects, providers);
        this.runtimeClasspath = objects.fileCollection().from(new Object[]{runtimeClasspath});
        this.outputDir = objects.directoryProperty().value(config.getOutputDir());
        this.projectLayout = projectLayout;
        this.execOperations = execOperations;
    }

    private Provider<Configuration> normalizedJooqConfigurationProvider(ObjectFactory objects, ProviderFactory providers) {
        Property normalizedConfiguration = objects.property(Configuration.class);
        normalizedConfiguration.set(providers.provider(() -> {
            Configuration clonedConfiguration = Objects.cloneObject(this.jooqConfiguration);
            OUTPUT_DIRECTORY_NORMALIZATION.execute((Object)clonedConfiguration);
            if (this.generationToolNormalization != null) {
                this.generationToolNormalization.execute((Object)clonedConfiguration);
            }
            return clonedConfiguration;
        }));
        normalizedConfiguration.finalizeValueOnRead();
        return normalizedConfiguration;
    }

    @Input
    public Provider<Configuration> getNormalizedJooqConfiguration() {
        return this.normalizedJooqConfiguration;
    }

    @Classpath
    public FileCollection getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    @OutputDirectory
    public Provider<Directory> getOutputDir() {
        return this.outputDir;
    }

    @Internal
    public Action<? super JavaExecSpec> getJavaExecSpec() {
        return this.javaExecSpec;
    }

    public void setJavaExecSpec(Action<? super JavaExecSpec> javaExecSpec) {
        this.javaExecSpec = javaExecSpec;
    }

    @Internal
    public Action<? super ExecResult> getExecResultHandler() {
        return this.execResultHandler;
    }

    public void setExecResultHandler(Action<? super ExecResult> execResultHandler) {
        this.execResultHandler = execResultHandler;
    }

    @Internal
    public Action<? super Configuration> getGenerationToolNormalization() {
        return this.generationToolNormalization;
    }

    public void setGenerationToolNormalization(Action<? super Configuration> generationToolNormalization) {
        this.generationToolNormalization = generationToolNormalization;
    }

    @TaskAction
    public void generate() {
        this.ensureStrategyIsValid(this.jooqConfiguration.getGenerator().getStrategy());
        this.jooqConfiguration.getGenerator().getTarget().setDirectory(((Directory)this.outputDir.get()).getAsFile().getAbsolutePath());
        File configFile = new File(this.getTemporaryDir(), "config.xml");
        this.writeConfiguration(this.jooqConfiguration, configFile);
        ExecResult execResult = this.executeJooq(configFile);
        if (this.execResultHandler != null) {
            this.execResultHandler.execute((Object)execResult);
        }
    }

    private void ensureStrategyIsValid(Strategy strategy) {
        if (strategy.getMatchers() != null) {
            strategy.setName(null);
        }
    }

    private void writeConfiguration(Configuration config, File file) {
        try (FileOutputStream fs = new FileOutputStream(file);){
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = sf.newSchema(GenerationTool.class.getResource("/xsd/" + this.xsdFileName()));
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setSchema(schema);
            marshaller.marshal((Object)config, (OutputStream)fs);
        }
        catch (IOException | JAXBException | SAXException e) {
            throw new TaskExecutionException((Task)this, e);
        }
    }

    private String xsdFileName() {
        try {
            Class<?> aClass = Class.forName("org.jooq.Constants");
            return (String)aClass.getDeclaredField("XSD_CODEGEN").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
    }

    private ExecResult executeJooq(File configFile) {
        return this.execOperations.javaexec(spec -> {
            spec.setMain("org.jooq.codegen.GenerationTool");
            spec.setClasspath((FileCollection)this.runtimeClasspath);
            spec.setWorkingDir((Object)this.projectLayout.getProjectDirectory());
            spec.args(new Object[]{configFile});
            if (this.javaExecSpec != null) {
                this.javaExecSpec.execute(spec);
            }
        });
    }
}

