/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public final class Objects {
    public static int deepHashCode(Object element) {
        if (element == null) {
            return 0;
        }
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(element);
        int result = 1;
        while (!stack.isEmpty()) {
            Object current = stack.removeFirst();
            if (current == null) {
                result = Objects.calculateHashCode(null, result);
                continue;
            }
            Class<?> currentClass = current.getClass();
            if (currentClass.isArray()) {
                stack.addFirst(currentClass.getName());
                int len = Array.getLength(current);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(current, i));
                }
                continue;
            }
            if (current instanceof List) {
                stack.addFirst(currentClass.getName());
                stack.addAll(0, (List)current);
                continue;
            }
            if (current instanceof SortedSet) {
                stack.addFirst(currentClass.getName());
                stack.addAll(0, (SortedSet)current);
                continue;
            }
            if (current instanceof Collection) {
                stack.addFirst(currentClass.getName());
                List sortedByDeepHashCode = Objects.sort((Collection)current, DeepHashCodeComparator.INSTANCE);
                stack.addAll(0, sortedByDeepHashCode);
                continue;
            }
            if (current instanceof SortedMap) {
                stack.addFirst(currentClass.getName());
                stack.addAll(0, ((Map)current).keySet());
                stack.addAll(0, ((Map)current).values());
                continue;
            }
            if (current instanceof Map) {
                stack.addFirst(currentClass.getName());
                TreeMap sortedByDeepHashCode = new TreeMap(DeepHashCodeComparator.INSTANCE);
                sortedByDeepHashCode.putAll((Map)current);
                stack.addAll(0, sortedByDeepHashCode.keySet());
                stack.addAll(0, sortedByDeepHashCode.values());
                continue;
            }
            if (Objects.hasCustomHashCode(currentClass)) {
                result = Objects.calculateHashCode(currentClass.getName(), result);
                result = Objects.calculateHashCode(current, result);
                continue;
            }
            Collection<Field> fields = Objects.getInstanceFields(currentClass);
            for (Field field : fields) {
                stack.addFirst(Objects.getFieldValue(field, current));
            }
        }
        return result;
    }

    private static Collection<Field> getInstanceFields(Class clazz) {
        ArrayList<Field> fieldsInHierarchy = new ArrayList<Field>();
        for (Class current = clazz; current != null; current = current.getSuperclass()) {
            ArrayList<Field> instanceFields = new ArrayList<Field>();
            for (Field field : current.getDeclaredFields()) {
                if (!Objects.isInstanceField(field)) continue;
                instanceFields.add(field);
            }
            List sortedInstanceFields = Objects.sort(instanceFields, FieldNameComparator.INSTANCE);
            fieldsInHierarchy.addAll(sortedInstanceFields);
        }
        return fieldsInHierarchy;
    }

    private static boolean isInstanceField(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !field.getName().startsWith("this$");
    }

    private static Object getFieldValue(Field field, Object object) {
        Objects.makeFieldAccessibleIfNeeded(field);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException shouldNeverHappen) {
            throw new RuntimeException(shouldNeverHappen);
        }
    }

    private static void makeFieldAccessibleIfNeeded(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    private static boolean hasCustomHashCode(Class<?> c) {
        try {
            Class<?> declaringClass = c.getMethod("hashCode", new Class[0]).getDeclaringClass();
            return !declaringClass.equals(Object.class);
        }
        catch (NoSuchMethodException shouldNeverHappen) {
            throw new RuntimeException(shouldNeverHappen);
        }
    }

    private static int calculateHashCode(Object element, int currentResult) {
        return 31 * currentResult + (element == null ? 0 : element.hashCode());
    }

    private static <T> List<T> sort(Collection<? extends T> current, Comparator<T> comparator) {
        ArrayList<? extends T> result = new ArrayList<T>(current);
        Collections.sort(result, comparator);
        return result;
    }

    private static final class DeepHashCodeComparator
    implements Comparator<Object> {
        private static final Comparator<Object> INSTANCE = new DeepHashCodeComparator();

        private DeepHashCodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int h2;
            int h1 = Objects.deepHashCode(o1);
            return h1 < (h2 = Objects.deepHashCode(o2)) ? -1 : (h1 == h2 ? 0 : 1);
        }
    }

    private static final class FieldNameComparator
    implements Comparator<Field> {
        private static final Comparator<Field> INSTANCE = new FieldNameComparator();

        private FieldNameComparator() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return n1.compareTo(n2);
        }
    }
}

