package nu.studer.gradle.jooq

import nu.studer.gradle.util.BridgeExtension
import org.gradle.api.internal.tasks.DefaultSourceSet
import org.jooq.util.jaxb.Configuration

def ext = new JooqExtension("myPath")
ext.registerSourceSet(new DefaultSourceSet("main", null))
ext.metaClass."main" = { Closure c ->
}

ext.main {
    println "in closure"
}

// ---

def config2 = new BridgeExtension(new Configuration(), "bar")

def config = new BridgeExtension(new Configuration(), "foo")
config.metaClass."main" = { "lllll" }
println config.main()

println config2.main()


def x = 4

def extension = new JooqExtension("root")
extension.main {
    "$configs"

//    jdbc {
//        println "$x fooo $x $configs"
//        driver = 'hello'
//    }
}

def driver = extension.main.target.jdbc.driver
if (driver != 'hello') throw new RuntimeException("Driver name should be 'hello'")

