/*
 * Decompiled with CFR 0.152.
 */
package nu.studer.gradle.credentials;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import nu.studer.gradle.credentials.domain.CredentialsEncryptor;
import nu.studer.gradle.credentials.domain.CredentialsPersistenceManager;
import nu.studer.java.util.OrderedProperties;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCredentialsTask
extends DefaultTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddCredentialsTask.class);
    private CredentialsEncryptor credentialsEncryptor;
    private CredentialsPersistenceManager credentialsPersistenceManager;
    private String key;
    private String value;

    public void setCredentialsEncryptor(CredentialsEncryptor credentialsEncryptor) {
        this.credentialsEncryptor = credentialsEncryptor;
    }

    public void setCredentialsPersistenceManager(CredentialsPersistenceManager credentialsPersistenceManager) {
        this.credentialsPersistenceManager = credentialsPersistenceManager;
    }

    @Option(option="key", description="The credentials key.")
    public void setKey(String key) {
        this.key = key;
    }

    @Option(option="value", description="The credentials value.")
    public void setValue(String value) {
        this.value = value;
    }

    @Input
    public String getCredentialsKey() {
        return this.key != null ? this.key : this.getProjectProperty("credentialsKey");
    }

    @Input
    public String getCredentialsValue() {
        return this.value != null ? this.value : this.getProjectProperty("credentialsValue");
    }

    @OutputFile
    public File getEncryptedPropertiesFile() {
        return this.credentialsPersistenceManager.getCredentialsFile();
    }

    @TaskAction
    void addCredentials() throws IOException {
        String key = this.getCredentialsKey();
        String value = this.getCredentialsValue();
        char[] placeholderValue = new char[value.length()];
        Arrays.fill(placeholderValue, '*');
        LOGGER.debug(String.format("Add credentials with key: '%s', value: '%s'", key, new String(placeholderValue)));
        OrderedProperties credentials = this.credentialsPersistenceManager.readCredentials();
        String encryptedValue = this.credentialsEncryptor.encrypt(value);
        credentials.setProperty(key, encryptedValue);
        this.credentialsPersistenceManager.storeCredentials(credentials);
    }

    private String getProjectProperty(String key) {
        return (String)this.getProject().getProperties().get(key);
    }
}

