/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.xml.dom;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nu.mine.mosher.xml.sax.ErrorHandlerImpl;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DomUtils {
    public static Document asDom(URL xml, boolean validate, List<URL> schemas) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder builder = DomUtils.factory(validate, schemas).newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandlerImpl());
        return builder.parse(xml.toExternalForm());
    }

    public static Document empty() throws ParserConfigurationException {
        return DomUtils.factory(false, Collections.emptyList()).newDocumentBuilder().newDocument();
    }

    private static DocumentBuilderFactory factory(boolean validate, List<URL> schemas) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validate);
        factory.setFeature("http://apache.org/xml/features/validation/schema", validate);
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(true);
        factory.setCoalescing(true);
        factory.setIgnoringElementContentWhitespace(false);
        factory.setIgnoringComments(false);
        factory.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        factory.setFeature("http://apache.org/xml/features/warn-on-duplicate-entitydef", true);
        factory.setFeature("http://apache.org/xml/features/standard-uri-conformant", true);
        factory.setFeature("http://apache.org/xml/features/xinclude", true);
        factory.setFeature("http://apache.org/xml/features/validate-annotations", true);
        factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        factory.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
        factory.setFeature("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", true);
        factory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        if (!schemas.isEmpty()) {
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", ((Stream)schemas.stream().sequential()).map(URL::toExternalForm).toArray(String[]::new));
        }
        return factory;
    }
}

