/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.xml.transform;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class TransformUtils {
    public static Node identity(Node dom) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transform = factory.newTransformer();
        TransformUtils.configTransformer(transform, false);
        DOMResult result = new DOMResult();
        transform.transform(new DOMSource(dom), result);
        return result.getNode();
    }

    public static void serialize(Node dom, BufferedOutputStream to, boolean pretty) throws IOException, TransformerException {
        DOMSource source = new DOMSource(dom);
        StreamResult result = new StreamResult(to);
        Transformer transformIdentity = TransformerFactory.newInstance().newTransformer();
        TransformUtils.configTransformer(transformIdentity, pretty);
        transformIdentity.transform(source, result);
        to.flush();
    }

    public static Node transform(Node dom, URL urlXslt, Map<String, Object> params, boolean initialTemplate) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (initialTemplate) {
            factory.setAttribute("http://saxon.sf.net/feature/initialTemplate", "{http://www.w3.org/1999/XSL/Transform}initial-template");
        }
        Transformer transform = factory.newTransformer(new StreamSource(urlXslt.toExternalForm()));
        TransformUtils.configTransformer(transform, false);
        params.forEach(transform::setParameter);
        DOMResult result = new DOMResult();
        transform.transform(new DOMSource(dom), result);
        return result.getNode();
    }

    private static void configTransformer(Transformer transform, boolean pretty) {
        transform.setOutputProperty("omit-xml-declaration", "no");
        transform.setOutputProperty("method", "xml");
        transform.setOutputProperty("encoding", "UTF-8");
        if (pretty) {
            transform.setOutputProperty("indent", "yes");
            transform.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
    }
}

