/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.xml;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nu.mine.mosher.xml.dom.DomUtils;
import nu.mine.mosher.xml.transform.TransformUtils;
import nu.mine.mosher.xml.validation.ValidationUtils;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XsltPipeline {
    private Node dom;
    private boolean validation;
    private List<URL> schema = new ArrayList<URL>();
    private boolean initialTemplate;
    private Map<String, Object> params = new HashMap<String, Object>();
    private boolean pretty = true;
    private boolean trace;

    public void trace(boolean trace) {
        this.trace = trace;
        this.traceHR();
        this.traceBool("trace", this.trace);
    }

    public void pretty(boolean pretty) {
        this.pretty = pretty;
        this.traceHR();
        this.traceBool("pretty", this.pretty);
    }

    public void dom(URL url) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        this.traceHR();
        this.dom = DomUtils.asDom(url, this.validation, this.schema);
        this.traceUrl("load dom", url);
        this.traceHR();
        this.traceXml(this.dom);
    }

    public void dom() throws ParserConfigurationException, IOException, TransformerException {
        this.traceHR();
        this.dom = DomUtils.empty();
        this.trace("generate empty dom");
        this.traceHR();
        this.traceXml(this.dom);
    }

    public void validation(boolean validation) {
        this.validation = validation;
        this.traceHR();
        this.traceBool("validation", this.validation);
    }

    public void initialTemplate(boolean initialTemplate) {
        this.initialTemplate = initialTemplate;
        this.traceHR();
        this.traceBool("initial-template", this.initialTemplate);
    }

    public void xsd(URL source) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.traceHR();
        this.schema.add(source);
        this.traceUrl("register xsd", source);
        this.traceHR();
        this.traceXml(DomUtils.asDom(source, false, Collections.emptyList()));
    }

    public void xsd() {
        this.traceHR();
        this.schema = new ArrayList<URL>();
        this.trace("dropping all registered schema");
    }

    public void xslt(URL source) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        this.traceHR();
        this.traceUrl("transform with xslt", source);
        this.traceHR();
        this.traceXml(DomUtils.asDom(source, false, Collections.emptyList()));
        this.dom = TransformUtils.transform(this.dom, source, this.params, this.initialTemplate);
        this.params = new HashMap<String, Object>();
        this.traceHR();
        this.traceXml(this.dom);
    }

    public void xslt() throws IOException, TransformerException {
        this.traceHR();
        this.trace("identity transform");
        this.dom = TransformUtils.identity(this.dom);
        this.traceHR();
        this.traceXml(this.dom);
    }

    public void validate() throws IOException, SAXException, TransformerException {
        for (URL xsd : this.schema) {
            this.traceHR();
            this.traceUrl("validate with xsd", xsd);
            this.dom = ValidationUtils.validate(this.dom, xsd);
            this.traceHR();
            this.traceXml(this.dom);
        }
    }

    public void param(String key, Object value) {
        this.traceHR();
        String s = Objects.toString(value);
        this.params.put(key, s);
        this.trace(String.format("parameter:  %s:%s", key, s));
    }

    public void serialize(BufferedOutputStream out) throws IOException, TransformerException {
        this.traceHR();
        this.trace("final output");
        this.traceHR();
        System.err.flush();
        TransformUtils.serialize(this.dom, out, this.pretty);
    }

    private void traceXml(Node dom) throws IOException, TransformerException {
        if (!this.trace) {
            return;
        }
        TransformUtils.serialize(dom, new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), true);
    }

    private void traceUrl(String label, URL url) {
        if (!this.trace) {
            return;
        }
        System.err.println(label + ": " + url);
    }

    private void traceBool(String label, boolean b) {
        if (!this.trace) {
            return;
        }
        System.err.println(label + ": " + b);
    }

    private void traceHR() {
        if (!this.trace) {
            return;
        }
        System.err.println("------------------------------------------------------------------------------------------------");
    }

    private void trace(String message) {
        if (!this.trace) {
            return;
        }
        System.err.println(message);
    }
}

