/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.xml;

import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nu.mine.mosher.xml.dom.DomUtils;
import nu.mine.mosher.xml.transform.TransformUtils;
import nu.mine.mosher.xml.validation.ValidationUtils;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XsltPipelineCliOptions {
    public Node dom = null;
    public boolean validation = false;
    public List<URL> schema = new ArrayList<URL>();
    public boolean initialTemplate = false;
    public Map<String, Object> params = new HashMap<String, Object>();
    public boolean pretty = true;
    public boolean trace = false;

    public static void help(Optional<String> unused) {
        System.err.println("Usage:");
        System.err.println();
        System.err.println("xslt-pipeline statement...");
        System.err.println();
        System.err.println("Statements:");
        System.err.println();
        System.err.println("--dom=input.xml");
        System.err.println("    parses an XML input URL/file into a DOM document (w/ or w/o validation using currently registered schema)");
        System.err.println("--dom");
        System.err.println("    generates an empty DOM document");
        System.err.println("--validation={true|false}");
        System.err.println("    sets validation mode on or off (doesn't actually validate)");
        System.err.println("    this option is for \"DOM validation\" not the Validator class");
        System.err.println("--xsd=ns_schema.xsd");
        System.err.println("    registers the given schema (can be used multiple times)");
        System.err.println("--xsd");
        System.err.println("    drops all currently registered schemas");
        System.err.println("--validate");
        System.err.println("    runs the Validator (not DOM validation) against the current DOM document, once for each registered schema");
        System.err.println("    this is not affected by the --validation={true|false} option");
        System.err.println("--xslt=ss.xslt");
        System.err.println("    runs current DOM document through the XSLT transformation");
        System.err.println("--xslt");
        System.err.println("    runs current DOM document through the identity XSLT transformation");
        System.err.println("--it={true|false}");
        System.err.println("    sets XSLT to start processing with xsl:initial-template, or not");
        System.err.println("--param=key:value");
        System.err.println("    sets parameter for XSLT processing");
        System.err.println("--pretty={true|false}");
        System.err.println("    indent final output XML; default: true");
        System.err.println("--trace={true|false}");
        System.err.println("    turn on or off tracing of statements on stderr; default: false");
    }

    public void trace(Optional<String> b) {
        this.trace = XsltPipelineCliOptions.parseBoolean("trace", b);
        this.traceHR();
        this.traceBool("trace", this.trace);
    }

    public void pretty(Optional<String> b) {
        this.pretty = XsltPipelineCliOptions.parseBoolean("pretty", b);
        this.traceHR();
        this.traceBool("pretty", this.pretty);
    }

    public void dom(Optional<String> source) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        this.traceHR();
        if (source.isPresent()) {
            URL url = XsltPipelineCliOptions.asUrl(source.get());
            this.dom = DomUtils.asDom(url, this.validation, this.schema);
            this.traceUrl("load dom", url);
            this.traceHR();
        } else {
            this.dom = DomUtils.empty();
            this.trace("generate empty dom");
            this.traceHR();
        }
        this.traceXml(this.dom);
    }

    public void validation(Optional<String> b) {
        this.validation = XsltPipelineCliOptions.parseBoolean("validation", b);
        this.traceHR();
        this.traceBool("validation", this.validation);
    }

    public void it(Optional<String> b) {
        this.initialTemplate = XsltPipelineCliOptions.parseBoolean("it", b);
        this.traceHR();
        this.traceBool("initial-template", this.initialTemplate);
    }

    public void xsd(Optional<String> source) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.traceHR();
        if (source.isPresent()) {
            URL url = XsltPipelineCliOptions.asUrl(source.get());
            this.schema.add(url);
            this.traceUrl("register xsd", url);
            this.traceHR();
            this.traceXml(DomUtils.asDom(url, false, Collections.emptyList()));
        } else {
            this.schema = new ArrayList<URL>();
            this.trace("dropping all registered schema");
        }
    }

    public void xslt(Optional<String> source) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        this.traceHR();
        if (source.isPresent()) {
            URL url = XsltPipelineCliOptions.asUrl(source.get());
            this.traceUrl("transform with xslt", url);
            this.traceHR();
            this.traceXml(DomUtils.asDom(url, false, Collections.emptyList()));
            this.dom = TransformUtils.transform(this.dom, url, this.params, this.initialTemplate);
            this.params = new HashMap<String, Object>();
        } else {
            this.trace("identity transform");
            this.dom = TransformUtils.identity(this.dom);
        }
        this.traceHR();
        this.traceXml(this.dom);
    }

    public void validate(Optional<String> notAllowed) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        if (notAllowed.isPresent()) {
            this.traceHR();
            throw new IllegalStateException("No value is allowed for option --validate");
        }
        for (URL xsd : this.schema) {
            this.traceHR();
            this.traceUrl("validate with xsd", xsd);
            this.dom = ValidationUtils.validate(this.dom, xsd);
            this.traceHR();
            this.traceXml(this.dom);
        }
    }

    public void param(Optional<String> keyColonValue) {
        this.traceHR();
        if (!keyColonValue.isPresent() || !keyColonValue.get().contains(":")) {
            throw new IllegalStateException("Invalid format for option --param=key:value");
        }
        String[] r2 = Arrays.copyOf(keyColonValue.get().split(":", 2), 2);
        this.params.put(r2[0], Objects.isNull(r2[1]) ? "" : r2[1]);
        this.trace(String.format("parameter:  %s:%s", r2[0], this.params.get(r2[0])));
    }

    private void traceXml(Node dom) throws IOException, TransformerException {
        if (!this.trace) {
            return;
        }
        TransformUtils.serialize(dom, new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), true);
    }

    private void traceUrl(String label, URL url) {
        if (!this.trace) {
            return;
        }
        System.err.println(label + ": " + url);
    }

    private void traceBool(String label, boolean b) {
        if (!this.trace) {
            return;
        }
        System.err.println(label + ": " + b);
    }

    private void traceHR() {
        if (!this.trace) {
            return;
        }
        System.err.println("------------------------------------------------------------------------------------------------");
    }

    private void trace(String message) {
        if (!this.trace) {
            return;
        }
        System.err.println(message);
    }

    private static boolean parseBoolean(String option, Optional<String> b) {
        boolean r;
        if (b.isPresent() && b.get().equalsIgnoreCase("true")) {
            r = true;
        } else if (b.isPresent() && b.get().equalsIgnoreCase("false")) {
            r = false;
        } else {
            throw new IllegalArgumentException(String.format("Invalid value for option --%s={true|false}", option));
        }
        return r;
    }

    private static URL asUrl(String pathOrUrl) throws IOException {
        try {
            return new URI(pathOrUrl).toURL();
        }
        catch (Throwable e) {
            Throwable urlExcept = e;
            try {
                return Paths.get(pathOrUrl, new String[0]).toUri().toURL();
            }
            catch (Throwable e2) {
                Throwable pathExcept = e2;
                IOException except = new IOException("Invalid path or URL: " + pathOrUrl);
                except.addSuppressed(pathExcept);
                except.addSuppressed(urlExcept);
                throw except;
            }
        }
    }
}

