/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nu.mine.mosher.xml.XsltPipeline;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TeiToXhtml5 {
    public static void transform(BufferedInputStream inTei, BufferedOutputStream outXhtml5, boolean createFullPage) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        XsltPipeline pipeline = new XsltPipeline();
        TeiToXhtml5.runPipeline(inTei, createFullPage, pipeline);
        pipeline.serialize(outXhtml5);
    }

    public static void transform(BufferedInputStream inTei, Node appendTo) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        XsltPipeline pipeline = new XsltPipeline();
        TeiToXhtml5.runPipeline(inTei, false, pipeline);
        appendTo.appendChild(appendTo.getOwnerDocument().importNode(pipeline.accessDom(), true));
    }

    private static void runPipeline(BufferedInputStream inTei, boolean createFullPage, XsltPipeline pipeline) throws ParserConfigurationException, IOException, SAXException, TransformerException {
        pipeline.dom(inTei);
        pipeline.xslt(TeiToXhtml5.lib("xslt/tei-copyOf.xslt"));
        pipeline.xslt(TeiToXhtml5.lib("xslt/tei-facs.xslt"));
        pipeline.xslt(TeiToXhtml5.lib("xslt/tei-norm-text.xslt"));
        pipeline.xslt(TeiToXhtml5.lib("xslt/tei-xhtml-specific.xslt"));
        pipeline.xslt(TeiToXhtml5.lib("xslt/tei-xhtml-general.xslt"));
        if (createFullPage) {
            pipeline.xslt(TeiToXhtml5.lib("xslt/tei-xhtml-page.xslt"));
            pipeline.xmldecl(true);
        }
    }

    public static String getCss() throws IOException {
        try (BufferedReader css = new BufferedReader(new InputStreamReader(TeiToXhtml5.class.getResourceAsStream("lib/css/tei.css"), StandardCharsets.UTF_8));){
            String string = css.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    public static void main(String ... args) throws IOException, TransformerException, ParserConfigurationException, SAXException {
        List ra = Arrays.stream(args).collect(Collectors.toUnmodifiableList());
        if (ra.contains("--help")) {
            System.out.println("usage: tei-to-xhtml5 <input.tei >output.xhtml5");
            System.out.println("       tei-to-xhtml5 --css >style.css");
        } else if (ra.contains("--css")) {
            System.out.println(TeiToXhtml5.getCss());
        } else {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(FileDescriptor.out));){
                TeiToXhtml5.transform(in, out, true);
            }
        }
        System.out.flush();
    }

    private static URL lib(String path) {
        return TeiToXhtml5.class.getResource("lib/" + path);
    }
}

