/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.patterns.fluent;

import com.google.common.xml.XmlEscapers;
import java.util.Deque;
import java.util.LinkedList;

public class Fragment {
    private final Deque<String> within = new LinkedList<String>();
    private final StringBuilder out = new StringBuilder(128);

    public Attribute elem(String name) {
        this.out.append("<").append(name);
        this.within.push(name);
        return new Attribute(this);
    }

    public Fragment text(String text) {
        this.out.append(Fragment.escText(text));
        return this;
    }

    public Fragment frag(String frag) {
        this.out.append(frag);
        return this;
    }

    public Fragment end() {
        if (!this.within.isEmpty()) {
            String elem = this.within.pop();
            this.out.append("</").append(elem).append(">");
        }
        return this;
    }

    public String toString() {
        while (!this.within.isEmpty()) {
            this.end();
        }
        return this.out.toString();
    }

    private static String escText(String s) {
        return XmlEscapers.xmlContentEscaper().escape(s);
    }

    private static String escAttr(String s) {
        return XmlEscapers.xmlAttributeEscaper().escape(s);
    }

    public static class Attribute
    extends Fragment {
        private final Fragment outer;

        private Attribute(Fragment fragment) {
            this.outer = fragment;
        }

        public Attribute attr(String name) {
            return this.attr(name, "");
        }

        public Attribute attr(String name, String value) {
            this.outer.out.append(" ").append(name).append("=\"").append(Fragment.escAttr(value)).append("\"");
            return this;
        }

        @Override
        public Attribute elem(String name) {
            this.outer.out.append(">");
            return this.outer.elem(name);
        }

        @Override
        public Fragment text(String text) {
            this.outer.out.append(">");
            return this.outer.text(text);
        }

        @Override
        public Fragment frag(String frag) {
            this.outer.out.append(">");
            return this.outer.frag(frag);
        }

        @Override
        public Fragment end() {
            this.outer.within.pop();
            this.outer.out.append("/>");
            return this.outer;
        }

        @Override
        public String toString() {
            this.end();
            return this.outer.toString();
        }
    }
}

