/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.xml;

import java.io.Closeable;
import java.util.Optional;

public class SysPropResetter
implements Closeable {
    private final String key;
    private final Optional<String> originalValue;

    public static SysPropResetter set(String key, Optional<String> value) {
        SysPropResetter instance = new SysPropResetter(key);
        SysPropResetter.setOrClearSysProp(key, value);
        return instance;
    }

    @Override
    public void close() {
        this.reset();
    }

    public void reset() {
        SysPropResetter.setOrClearSysProp(this.key, this.originalValue);
    }

    private SysPropResetter(String key) {
        this.key = key;
        this.originalValue = Optional.ofNullable(System.getProperty(this.key));
    }

    private static void setOrClearSysProp(String key, Optional<String> value) {
        if (value.isPresent()) {
            System.setProperty(key, value.get());
        } else {
            System.clearProperty(key);
        }
    }
}

