/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.xml;

import com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ErrorGatherer;
import net.sf.saxon.lib.ParseOptions;
import nu.mine.mosher.xml.SysPropSetter;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class SimpleXml {
    private static final int INITIAL_BUFFER_SIZE = 1024;
    private static final ClassLoader loader = SimpleXml.class.getClassLoader();
    private static final Class<? extends SAXParserFactory> classSaxParserFactory = SAXParserFactoryImpl.class;
    private static final Class<? extends TransformerFactory> classTransformerFactory = TransformerFactoryImpl.class;
    private static final Class<? extends SchemaFactory> classSchemaFactory = XMLSyntaxSchemaFactory.class;
    private final String original;
    private final String roundtrip;

    public SimpleXml(String xml) throws SAXParseException {
        this.original = xml;
        this.roundtrip = SimpleXml.roundtrip(xml);
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean isValid(String schema) {
        try {
            this.validate(schema);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void validate(String rng) throws SAXException {
        try {
            SimpleXml.createSchema(SimpleXml.asStreamSource(rng)).newValidator().validate(SimpleXml.asSaxSource(this.roundtrip));
        }
        catch (IOException io) {
            throw new IllegalStateException("Assumed no IOException would be thrown.", io);
        }
    }

    public String transform(String xslt) throws TransformerException {
        return this.transform(xslt, Collections.emptyMap());
    }

    public String transform(String xslt, Map<String, Object> params) throws TransformerException {
        StringWriter sOut = new StringWriter(1024);
        Transformer transformer = SimpleXml.createTransformer((Source)SimpleXml.asAugSaxSource(xslt));
        params.forEach((name, value) -> transformer.setParameter((String)name, this.convertValue(value)));
        transformer.transform(SimpleXml.asSaxSource(this.roundtrip), new StreamResult(sOut));
        return sOut.toString();
    }

    private String convertValue(Object value) {
        if (value instanceof Boolean) {
            return this.convertValue((Boolean)value != false ? 1 : 0);
        }
        return value.toString();
    }

    public String toString() {
        return this.roundtrip;
    }

    private static StreamSource asStreamSource(String s) {
        return new StreamSource(new StringReader(s));
    }

    private static String roundtrip(String xml) throws SAXParseException {
        StringWriter sOut = new StringWriter(1024);
        try {
            SimpleXml.createIdentityTransformer().transform((Source)SimpleXml.asNoerrSaxSource(xml), new StreamResult(sOut));
        }
        catch (TransformerException e) {
            SimpleXml.rewrapSaxParseException(e);
        }
        return sOut.toString();
    }

    private static void rewrapSaxParseException(TransformerException e) throws SAXParseException {
        Throwable cause = e.getCause();
        if (cause != null) {
            if (cause instanceof SAXParseException) {
                throw (SAXParseException)cause;
            }
            SAXParseException se = new SAXParseException(cause.getMessage(), null);
            se.initCause(cause);
            throw se;
        }
    }

    private static SAXParserFactory createSaxParserFactory() throws SAXException, ParserConfigurationException {
        SAXParserFactory f = SAXParserFactory.newInstance(classSaxParserFactory.getName(), loader);
        f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        f.setNamespaceAware(true);
        f.setXIncludeAware(false);
        return f;
    }

    private static SAXParser createSaxParser() {
        try {
            return SimpleXml.createSaxParserFactory().newSAXParser();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Assumed no exceptions would be thrown.", e);
        }
    }

    private static XMLReader createSaxReader() {
        try {
            return SimpleXml.createSaxParser().getXMLReader();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Assumed no exceptions would be thrown.", e);
        }
    }

    private static SAXSource asSaxSource(String xml) {
        return new SAXSource(SimpleXml.createSaxReader(), new InputSource(new StringReader(xml)));
    }

    private static AugmentedSource asNoerrSaxSource(String xml) {
        ParseOptions options = new ParseOptions();
        options.setErrorListener((ErrorListener)new ErrorGatherer(new ArrayList()));
        return new AugmentedSource((Source)SimpleXml.asSaxSource(xml), options);
    }

    private static AugmentedSource asAugSaxSource(String xml) {
        ParseOptions options = new ParseOptions();
        options.setXMLReader(SimpleXml.createSaxReader());
        return new AugmentedSource((Source)SimpleXml.asSaxSource(xml), options);
    }

    private static TransformerFactory createTransformerFactory() {
        return TransformerFactory.newInstance(classTransformerFactory.getName(), loader);
    }

    private static Transformer createIdentityTransformer() {
        try {
            return SimpleXml.createTransformerFactory().newTransformer();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Assumed no exceptions would be thrown.", e);
        }
    }

    private static Transformer createTransformer(Source s) throws TransformerConfigurationException {
        return SimpleXml.createTransformerFactory().newTransformer(s);
    }

    private static SchemaFactory createSchemaFactory() {
        return SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0", classSchemaFactory.getName(), loader);
    }

    private static Schema createSchema(Source s) throws SAXException {
        SchemaFactory factory = SimpleXml.createSchemaFactory();
        try (SysPropSetter p = new SysPropSetter(SAXParserFactory.class.getName()).set(classSaxParserFactory.getName());){
            Schema schema = factory.newSchema(s);
            return schema;
        }
    }
}

