/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.security.password;

import java.util.Objects;

public final class HashedString {
    private static final int MIN_ITERATIONS = 1;
    private static final int MAX_ITERATIONS = 0x10000000;
    private static final String DELIMITER = ":";
    private final int iterations;
    private final byte[] salt;
    private final byte[] hash;

    public HashedString(int iterations, byte[] salt, byte[] hash) throws InvalidFormat {
        try {
            this.iterations = HashedString.validIterationRange(iterations);
            this.salt = HashedString.nonEmptyCopy(salt);
            this.hash = HashedString.nonEmptyCopy(hash);
        }
        catch (InvalidFormat e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new InvalidFormat(cause);
        }
    }

    private static int validIterationRange(int iterations) throws InvalidFormat {
        if (iterations < 1 || 0x10000000 < iterations) {
            throw new InvalidFormat("Hash algorithm iterations must be between 1 and 268435456");
        }
        return iterations;
    }

    private static byte[] nonEmptyCopy(byte[] untrusted) throws InvalidFormat {
        byte[] klone = (byte[])Objects.requireNonNull(untrusted).clone();
        if (klone.length == 0) {
            throw new InvalidFormat("Missing salt or hash.");
        }
        return klone;
    }

    public static HashedString create(String untrustedInternalRepresentation) throws InvalidFormat {
        try {
            String[] parts = Objects.requireNonNull(untrustedInternalRepresentation).split(DELIMITER, 3);
            int iterations = Integer.parseInt(parts[0]);
            byte[] salt = HashedString.unhex(parts[1]);
            byte[] hash = HashedString.unhex(parts[2]);
            return new HashedString(iterations, salt, hash);
        }
        catch (InvalidFormat e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new InvalidFormat(cause);
        }
    }

    public String toString() {
        return this.iterations + DELIMITER + HashedString.hex(this.salt) + DELIMITER + HashedString.hex(this.hash);
    }

    static String hex(byte[] rb) {
        StringBuilder sb = new StringBuilder();
        for (byte b : rb) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    static byte[] unhex(String s) {
        if (s.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hex String, must be even number of characters.");
        }
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < s.length(); i += 2) {
            bytes[i / 2] = HashedString.hexToByte(s.substring(i, i + 2));
        }
        return bytes;
    }

    private static byte hexToByte(String hexAsciiTwoNibbles) {
        int hi = HashedString.nib(hexAsciiTwoNibbles.charAt(0));
        int lo = HashedString.nib(hexAsciiTwoNibbles.charAt(1));
        return (byte)(hi << 4 | lo);
    }

    private static int nib(char hexChar) {
        int n = Character.digit(hexChar, 16);
        if (n == -1) {
            throw new IllegalArgumentException("Invalid hex: " + hexChar);
        }
        return n;
    }

    public byte[] salt() {
        return (byte[])this.salt.clone();
    }

    public int iterations() {
        return this.iterations;
    }

    public int hashBitCount() {
        return this.hash.length * 8;
    }

    public byte[] hash() {
        return (byte[])this.hash.clone();
    }

    public static class InvalidFormat
    extends Exception {
        private InvalidFormat(String msg) {
            super(msg);
        }

        private InvalidFormat(Throwable cause) {
            super("Invalid hashed format", cause);
        }
    }
}

