/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.security.password;

import com.google.common.io.BaseEncoding;
import java.util.Objects;

public final class HashedString {
    private static final int MIN_ITERATIONS = 1;
    private static final int MAX_ITERATIONS = 0x10000000;
    private static final String DELIMITER = ":";
    private final int iterations;
    private final byte[] salt;
    private final byte[] hash;

    public HashedString(int iterations, byte[] salt, byte[] hash) throws InvalidFormat {
        try {
            this.iterations = HashedString.validIterationRange(iterations);
            this.salt = HashedString.nonEmptyCopy(salt);
            this.hash = HashedString.nonEmptyCopy(hash);
        }
        catch (InvalidFormat e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new InvalidFormat(cause);
        }
    }

    private static int validIterationRange(int iterations) throws InvalidFormat {
        if (iterations < 1 || 0x10000000 < iterations) {
            throw new InvalidFormat("Hash algorithm iterations must be between 1 and 268435456");
        }
        return iterations;
    }

    private static byte[] nonEmptyCopy(byte[] untrusted) throws InvalidFormat {
        byte[] klone = (byte[])Objects.requireNonNull(untrusted).clone();
        if (klone.length == 0) {
            throw new InvalidFormat("Missing salt or hash.");
        }
        return klone;
    }

    public static HashedString create(String untrustedInternalRepresentation) throws InvalidFormat {
        try {
            String[] parts = Objects.requireNonNull(untrustedInternalRepresentation).split(DELIMITER, 3);
            int iterations = Integer.parseInt(parts[0]);
            byte[] salt = HashedString.unhex(parts[1]);
            byte[] hash = HashedString.unhex(parts[2]);
            return new HashedString(iterations, salt, hash);
        }
        catch (InvalidFormat e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new InvalidFormat(cause);
        }
    }

    public String toString() {
        return Integer.toString(this.iterations) + DELIMITER + HashedString.hex(this.salt) + DELIMITER + HashedString.hex(this.hash);
    }

    private static String hex(byte[] rb) {
        return BaseEncoding.base16().encode(rb);
    }

    private static byte[] unhex(String s) {
        return BaseEncoding.base16().decode((CharSequence)s);
    }

    public byte[] salt() {
        return (byte[])this.salt.clone();
    }

    public int iterations() {
        return this.iterations;
    }

    public int hashBitCount() {
        return this.hash.length * 8;
    }

    public byte[] hash() {
        return (byte[])this.hash.clone();
    }

    public static class InvalidFormat
    extends Exception {
        private InvalidFormat(String msg) {
            super(msg);
        }

        private InvalidFormat(Throwable cause) {
            super("Invalid hashed format", cause);
        }
    }
}

