/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.security.password;

import java.io.Console;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import nu.mine.mosher.security.password.HashedString;
import nu.mine.mosher.security.password.SaltUtil;

public final class StrongHash {
    private static final int ITERATIONS = 101021;
    private static final int KEY_BYTE_COUNT = 64;
    private static final String HASHING_ALGORITHM_NAME = "PBKDF2WithHmacSHA1";

    StrongHash() {
        throw new IllegalStateException("Do not instantiate.");
    }

    private static SecretKeyFactory skf() {
        try {
            return SecretKeyFactory.getInstance(HASHING_ALGORITHM_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] hashFor(PBEKeySpec spec) throws InvalidKeySpecException {
        return StrongHash.skf().generateSecret(spec).getEncoded();
    }

    private static String serializeHash(int iterations, byte[] salt, byte[] hash) throws InvalidKeySpecException {
        try {
            return new HashedString(iterations, salt, hash).toString();
        }
        catch (HashedString.InvalidFormat e) {
            throw new InvalidKeySpecException(e);
        }
    }

    public static void main(String ... args) throws InvalidKeySpecException {
        if (args.length > 0) {
            throw new IllegalArgumentException("Invalid option specified.");
        }
        Console console = System.console();
        if (Objects.isNull(console)) {
            throw new UnsupportedOperationException("Pass-phrases must be entered manually in the console.");
        }
        char[] password = console.readPassword("%s: ", "pass-phrase");
        System.out.println(StrongHash.hash(new String(password)));
        System.out.flush();
    }

    public static boolean isPasswordValid(String guess, String storedHashRepresentation) throws HashedString.InvalidFormat {
        if (Objects.requireNonNull(guess).isEmpty()) {
            return false;
        }
        HashedString stored = HashedString.create(Objects.requireNonNull(storedHashRepresentation));
        PBEKeySpec spec = new PBEKeySpec(guess.toCharArray(), stored.salt(), stored.iterations(), stored.hashBitCount());
        try {
            return Arrays.equals(StrongHash.hashFor(spec), stored.hash());
        }
        catch (InvalidKeySpecException ignore) {
            return false;
        }
    }

    public static String hash(String password) throws InvalidKeySpecException {
        if (Objects.requireNonNull(password).isEmpty()) {
            throw new InvalidKeySpecException("Password cannot be empty.");
        }
        byte[] salt = SaltUtil.generateRandom();
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 101021, 512);
        return StrongHash.serializeHash(101021, salt, StrongHash.hashFor(spec));
    }

    static {
        StrongHash.skf();
    }
}

