/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.io;

import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogFiles {
    private static final Pattern CAMEL = Pattern.compile("(?=[A-Z0-9])");

    public static File getLogFileOf(Class cls) {
        String app = cls.getName();
        Optional<String> freedesktopCache = Optional.ofNullable(System.getenv("XDG_CACHE_HOME"));
        Path dirLogs = freedesktopCache.isPresent() ? Paths.get(freedesktopCache.get(), new String[0]).resolve(app).resolve("logs") : (LogFiles.os().startsWith("win") ? LogFiles.localAppData().resolve(app).resolve("Logs") : (LogFiles.os().startsWith("mac") ? LogFiles.home().resolve("Library").resolve("Logs").resolve(app) : LogFiles.home().resolve(".cache").resolve(app).resolve("logs")));
        String nameLog = LogFiles.low(cls.getSimpleName()) + ".log";
        File fileLog = dirLogs.resolve(nameLog).toFile();
        fileLog.getParentFile().mkdirs();
        return fileLog;
    }

    private static Path localAppData() {
        try {
            return Paths.get(Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_LocalAppData), new String[0]);
        }
        catch (Throwable throwable) {
            try {
                return Paths.get(Shell32Util.getFolderPath((int)28), new String[0]);
            }
            catch (Throwable throwable2) {
                return LogFiles.home().resolve("AppData").resolve("Local");
            }
        }
    }

    private static Path home() {
        String def = "./";
        try {
            return Paths.get(System.getProperty("user.home", "./"), new String[0]);
        }
        catch (Throwable throwable) {
            return Paths.get("./", new String[0]);
        }
    }

    private static String os() {
        String def = "*ux";
        try {
            return System.getProperty("os.name", "*ux").toLowerCase();
        }
        catch (Throwable throwable) {
            return "*ux";
        }
    }

    private static String low(String s) {
        Matcher matcher = CAMEL.matcher(s);
        s = matcher.replaceAll("-");
        if ((s = s.toLowerCase()).startsWith("-")) {
            s = s.substring(1);
        }
        return s;
    }
}

