/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.graph.datawebapp.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nu.mine.mosher.graph.datawebapp.util.Utils;
import nu.mine.mosher.graph.datawebapp.view.PageEdit;
import nu.mine.mosher.graph.datawebapp.view.PageView;
import nu.mine.mosher.graph.datawebapp.view.SecurePage;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.PropertyListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.component.IRequestablePage;

public class PageList
extends SecurePage {
    public PageList(Class cls) {
        this(cls, "", 0, 50);
    }

    private PageList(Class cls, String search, int page, int sizePage) {
        List<Serializable> entities = PageList.loadList(cls, search, page, sizePage);
        this.add(new Component[]{new Label("entity", (Serializable)((Object)cls.getSimpleName()))});
        this.add(new Component[]{new SearchForm(cls, search, sizePage)});
        this.add(new Component[]{new ListEntity(entities)});
        this.add(new Component[]{new WebMarkupContainer("empty").setVisible(entities.size() < sizePage)});
        this.add(new Component[]{new LinkNew(cls)});
        this.add(new Component[]{new LinkPage("prev", cls, page - 1, search, sizePage).setEnabled(0 < page)});
        this.add(new Component[]{new Label("page", (IModel)new StringResourceModel("page", (IModel)Model.of((Serializable)new Page(page))))});
        this.add(new Component[]{new LinkPage("next", cls, page + 1, search, sizePage).setEnabled(sizePage <= entities.size())});
    }

    private static List<Serializable> loadList(Class cls, String search, int page, int sizePage) {
        return search.isEmpty() ? PageList.recent(cls) : PageList.search(search, cls, page, sizePage);
    }

    private static List<Serializable> recent(Class cls) {
        return Collections.emptyList();
    }

    private static List<Serializable> search(String anytext, Class cls, int page, int sizePage) {
        if (page < 0) {
            return Collections.emptyList();
        }
        Iterable resultset = Utils.ogm().query(cls, PageList.getNodeOrRelationshipQuery(cls), Map.of("anytext", anytext, "skip", page * sizePage, "sizePage", sizePage));
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        resultset.forEach(result::add);
        return result;
    }

    private static String getNodeOrRelationshipQuery(Class cls) {
        String query = Utils.store().isNodeEntity(cls) ? "CALL db.index.fulltext.queryNodes('fulltextNode', $anytext) YIELD node AS x WHERE x:" + cls.getSimpleName() + " RETURN x " : "CALL db.index.fulltext.queryRelationships('fulltextRelationship', $anytext) YIELD relationship AS x MATCH (n)-[x:" + cls.getSimpleName() + "]-(m) RETURN n,x,m ";
        query = query + "ORDER BY x.id SKIP $skip LIMIT $sizePage";
        return query;
    }

    private static class SearchForm
    extends Form<Void> {
        private final Class c;
        private String search;
        private int sizePage;

        public SearchForm(Class c, String search, int sizePage) {
            super("form");
            this.c = c;
            this.search = search;
            this.sizePage = sizePage;
            this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
            this.add(new Component[]{new TextField("search")});
        }

        protected void onSubmit() {
            this.setResponsePage((IRequestablePage)new PageList(this.c, this.search, 0, this.sizePage));
        }
    }

    private static final class LinkNew
    extends Link<Void> {
        private final Class cls;

        public LinkNew(Class cls) {
            super("new");
            this.cls = cls;
        }

        public void onClick() {
            this.setResponsePage((IRequestablePage)new PageEdit(this.cls, null, null));
        }
    }

    private static final class LinkEntity
    extends Link<Void> {
        private final Serializable entity;

        public LinkEntity(Serializable entity) {
            super("link");
            this.entity = entity;
            this.add(new Component[]{new Label("entity", (Serializable)((Object)Utils.str(entity)))});
        }

        public void onClick() {
            this.setResponsePage((IRequestablePage)new PageView(this.entity.getClass(), Utils.id(this.entity), Utils.uuid(this.entity)));
        }
    }

    private static final class ListEntity
    extends PropertyListView<Serializable> {
        public ListEntity(List<Serializable> entities) {
            super("list", entities);
        }

        protected void populateItem(ListItem item) {
            item.add(new Component[]{new LinkEntity((Serializable)item.getModelObject())});
        }
    }

    private static class LinkPage
    extends Link<Void> {
        private final Class cls;
        private int page;
        private final String search;
        private final int sizePage;

        public LinkPage(String id, Class cls, int page, String search, int sizePage) {
            super(id);
            this.cls = cls;
            this.page = page;
            this.search = search;
            this.sizePage = sizePage;
        }

        public void onClick() {
            this.setResponsePage((IRequestablePage)new PageList(this.cls, this.search, this.page, this.sizePage));
        }
    }

    private static class Page
    implements Serializable {
        int page;

        Page(int p) {
            this.page = p + 1;
        }
    }
}

