/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.graph.datawebapp.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import nu.mine.mosher.graph.datawebapp.GraphDataWebApp;
import nu.mine.mosher.graph.datawebapp.store.Store;
import nu.mine.mosher.graph.datawebapp.util.Props;
import org.apache.wicket.Application;
import org.apache.wicket.model.PropertyModel;
import org.neo4j.ogm.exception.OptimisticLockingException;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.Session;

public final class Utils {
    public static Serializable create(Class cls) {
        try {
            return Utils.initEntity(Utils.instance(cls));
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static MetaData metaData() {
        return Utils.store().getSession().metadata();
    }

    public static String str(Object object) {
        return Objects.isNull(object) ? "" : object.toString();
    }

    public static Serializable resetEntity(Serializable entity) {
        new PropertyModel((Object)entity, "id").setObject(null);
        new PropertyModel((Object)entity, "version").setObject(null);
        return entity;
    }

    public static UUID uuid(Object entity) {
        return Utils.prop(entity, "uuid", UUID.class);
    }

    public static Long id(Object entity) {
        return Utils.prop(entity, "id", Long.class);
    }

    public static <T> T prop(Object object, String nameProperty, Class<T> cls) {
        return (T)new PropertyModel(Objects.requireNonNull(object), Objects.requireNonNull(nameProperty)).getObject();
    }

    public static Serializable same(UUID expected, Object entity) {
        UUID actual = Utils.uuid(Objects.requireNonNull(entity));
        if (!actual.equals(Objects.requireNonNull(expected))) {
            throw new OptimisticLockingException("Retrieved unexpected object from database: expected=" + expected + ", actual=" + actual);
        }
        return (Serializable)entity;
    }

    public static Store store() {
        return Utils.app().store();
    }

    public static Props props() {
        return Utils.app().props();
    }

    public static Session ogm() {
        return Utils.store().getSession().session();
    }

    public static GraphDataWebApp app() {
        return (GraphDataWebApp)Application.get();
    }

    private static Serializable instance(Class cls) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return (Serializable)Arrays.stream(cls.getDeclaredConstructors()).filter(c -> c.getGenericParameterTypes().length == 0).findAny().orElseThrow().newInstance(new Object[0]);
    }

    private static Serializable initEntity(Serializable entity) {
        new PropertyModel((Object)entity, "uuid").setObject((Object)UUID.randomUUID());
        new PropertyModel((Object)entity, "utcCreated").setObject((Object)ZonedDateTime.now(ZoneOffset.UTC));
        return entity;
    }

    private Utils() {
    }
}

