/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.graph.datawebapp.store;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import nu.mine.mosher.graph.datawebapp.store.Neo4jConnection;
import nu.mine.mosher.graph.datawebapp.util.GraphEntity;
import nu.mine.mosher.graph.datawebapp.util.Utils;
import org.apache.wicket.Session;
import org.neo4j.ogm.metadata.ClassInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Store
implements AutoCloseable {
    private final Logger LOG = LoggerFactory.getLogger(Store.class);
    private final Cache<String, Neo4jConnection> connections = Caffeine.newBuilder().removalListener((id, conn, cause) -> conn.close()).expireAfterWrite(1L, TimeUnit.HOURS).build();

    public Store() {
        Scheduler.systemScheduler().schedule((Executor)ForkJoinPool.commonPool(), () -> this.connections.cleanUp(), 5L, TimeUnit.MINUTES);
    }

    public boolean isEntity(Class cls) {
        return Objects.nonNull(Utils.metaData().classInfo(cls));
    }

    public boolean isNodeEntity(Class cls) {
        ClassInfo info = Utils.metaData().classInfo(cls);
        return Objects.nonNull(info) && !info.isRelationshipEntity();
    }

    public List<Class> entityClasses() {
        return Utils.metaData().persistentEntities().stream().map(ClassInfo::getUnderlyingClass).filter(c -> !c.equals(GraphEntity.class)).collect(Collectors.toUnmodifiableList());
    }

    public void createSession(String bolt, String username, String password, String ... packages) {
        String id = Session.get().getId();
        try {
            this.connections.put((Object)id, (Object)new Neo4jConnection(bolt, username, password, packages));
        }
        catch (RuntimeException cantConnect) {
            this.LOG.warn("Cannot connect", (Throwable)cantConnect);
        }
    }

    public Neo4jConnection getSession() {
        String id = Session.get().getId();
        return Optional.ofNullable((Neo4jConnection)this.connections.getIfPresent((Object)id)).orElseThrow();
    }

    public boolean haveSession() {
        String id = Session.get().getId();
        return Objects.nonNull(this.connections.getIfPresent((Object)id));
    }

    public void dropSession() {
        String id = Session.get().getId();
        this.connections.invalidate((Object)id);
    }

    @Override
    public void close() {
        this.connections.invalidateAll();
        try {
            ForkJoinPool.commonPool().awaitTermination(7L, TimeUnit.SECONDS);
        }
        catch (InterruptedException propagate) {
            this.LOG.warn("interrupted", (Throwable)propagate);
            Thread.currentThread().interrupt();
        }
        this.connections.cleanUp();
    }
}

