/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.mosher.graph.datawebapp.view;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import nu.mine.mosher.graph.datawebapp.util.Props;
import nu.mine.mosher.graph.datawebapp.util.Utils;
import nu.mine.mosher.graph.datawebapp.view.PageChoose;
import nu.mine.mosher.graph.datawebapp.view.PageEdit;
import nu.mine.mosher.graph.datawebapp.view.PageList;
import nu.mine.mosher.graph.datawebapp.view.SecurePage;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;

public class PageView
extends SecurePage {
    private final Serializable entity;

    public PageView(Class cls, Long id, UUID uuid) {
        this.entity = Utils.same(uuid, Utils.ogm().load(cls, (Serializable)Objects.requireNonNull(id)));
        this.init();
    }

    public PageView(Serializable entity) {
        this.entity = Objects.requireNonNull(entity);
        this.init();
    }

    private void init() {
        this.add(new Component[]{new Link<Void>("list"){

            public void onClick() {
                this.setResponsePage((IRequestablePage)new PageList(PageView.this.entity.getClass()));
            }
        }});
        this.add(new Component[]{new Label("entity", (Serializable)((Object)this.entity.getClass().getSimpleName()))});
        this.add(new Component[]{new Link<Void>("edit"){

            public void onClick() {
                this.setResponsePage((IRequestablePage)new PageEdit(PageView.this.entity.getClass(), Utils.id(PageView.this.entity), Utils.uuid(PageView.this.entity)));
            }
        }});
        this.add(new Component[]{new ListView<Props.Prop>("properties", Utils.props().properties(this.entity.getClass())){

            protected void populateItem(ListItem<Props.Prop> item) {
                String nameProperty = ((Props.Prop)item.getModelObject()).name;
                item.add(new Component[]{new Label("name", (Serializable)((Object)nameProperty))});
                item.add(new Component[]{new Label("property", (IModel)new PropertyModel((Object)PageView.this.entity, nameProperty))});
            }
        }.setReuseItems(true)});
        this.add(new Component[]{new ListView<Props.Ref>("refsMultiple", Utils.props().refsMultiple(this.entity.getClass())){

            protected void populateItem(ListItem<Props.Ref> item) {
                final Props.Ref ref = (Props.Ref)item.getModelObject();
                Component name = new Label("name", (Serializable)((Object)ref.name)).setRenderBodyOnly(true);
                item.add(new Component[]{name});
                Collection referents = (Collection)new PropertyModel((Object)PageView.this.entity, ref.name).getObject();
                item.add(new Component[]{new ReferenceListView(ref, referents)});
                item.add(new Component[]{new WebMarkupContainer("empty").setVisible((long)referents.size() == 0L)});
                item.add(new Component[]{new Link<Void>("add"){

                    public void onClick() {
                        this.setResponsePage((IRequestablePage)new PageEdit(ref.cls, null, null));
                    }
                }});
            }

            class ReferenceListView
            extends ListView<Serializable> {
                private final Props.Ref ref;

                public ReferenceListView(Props.Ref ref, Collection referents) {
                    super("ref", List.copyOf(referents));
                    this.ref = ref;
                }

                protected void populateItem(ListItem<Serializable> item) {
                    Serializable referent = (Serializable)item.getModelObject();
                    item.add(new Component[]{new LinkEntity(referent)});
                    item.add(new Component[]{new LinkRemove(this.ref, referent)});
                }
            }
        }});
        this.add(new Component[]{new ListView<Props.Ref>("refsSingular", Utils.props().refsSingular(this.entity.getClass())){

            protected void populateItem(ListItem<Props.Ref> item) {
                final Props.Ref ref = (Props.Ref)item.getModelObject();
                Component name = new Label("name", (Serializable)((Object)ref.name)).setRenderBodyOnly(true);
                item.add(new Component[]{name});
                Serializable referent = (Serializable)new PropertyModel((Object)PageView.this.entity, ref.name).getObject();
                item.add(new Component[]{new LinkEntity(referent).setVisible(Objects.nonNull(referent))});
                item.add(new Component[]{new LinkRemove(ref, referent).setVisible(Objects.nonNull(referent))});
                item.add(new Component[]{new WebMarkupContainer("empty").setVisible(Objects.isNull(referent))});
                item.add(new Component[]{new Link<Void>("add"){

                    public void onClick() {
                        this.setResponsePage((IRequestablePage)new PageChoose(PageView.this.entity, ref));
                    }
                }.setVisible(Objects.isNull(referent))});
            }
        }});
        this.add(new Component[]{new Link<Void>("delete"){

            public void onClick() {
                Utils.ogm().delete((Object)PageView.this.entity);
                this.setResponsePage((IRequestablePage)new PageList(PageView.this.entity.getClass()));
            }
        }});
    }

    private static final class LinkEntity
    extends Link<Void> {
        private final Serializable referent;

        public LinkEntity(Serializable referent) {
            super("link");
            this.referent = referent;
            this.add(new Component[]{new Label("entity", (Serializable)((Object)Utils.str(referent)))});
        }

        public void onClick() {
            this.setResponsePage((IRequestablePage)new PageView(this.referent.getClass(), Utils.id(this.referent), Utils.uuid(this.referent)));
        }
    }

    private final class LinkRemove
    extends Link<Void> {
        private final Props.Ref ref;
        private final Serializable referent;

        public LinkRemove(Props.Ref ref, Serializable referent) {
            super("remove");
            this.ref = ref;
            this.referent = referent;
        }

        public void onClick() {
            if (this.ref.collection) {
                ((Collection)new PropertyModel((Object)PageView.this.entity, this.ref.name).getObject()).remove(this.referent);
            } else {
                new PropertyModel((Object)PageView.this.entity, this.ref.name).setObject(null);
            }
            try {
                Utils.ogm().save((Object)PageView.this.entity);
                this.setResponsePage((IRequestablePage)new PageView(PageView.this.entity.getClass(), Utils.id(PageView.this.entity), Utils.uuid(PageView.this.entity)));
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.setResponsePage((IRequestablePage)new PageView(PageView.this.entity));
            }
        }
    }
}

